/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.util.Clock;
import java.util.Arrays;
import java.util.Iterator;

public class EvictorImpl
implements Evictor {
    protected static final int ONE_HUNDRED_PERCENT = 100;
    protected final MapServiceContext mapServiceContext;
    protected final EvictionChecker evictionChecker;

    public EvictorImpl(EvictionChecker evictionChecker, MapServiceContext mapServiceContext) {
        this.evictionChecker = evictionChecker;
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public EvictionChecker getEvictionChecker() {
        return this.evictionChecker;
    }

    @Override
    public void removeSize(int removalSize, RecordStore recordStore) {
        long now = Clock.currentTimeMillis();
        MapConfig mapConfig = recordStore.getMapContainer().getMapConfig();
        boolean backup = this.isBackup(recordStore);
        EvictionPolicy evictionPolicy = mapConfig.getEvictionPolicy();
        long[] criterias = this.createAndPopulateEvictionCriteriaArray(recordStore, evictionPolicy);
        if (criterias == null) {
            return;
        }
        Arrays.sort(criterias);
        int evictableBaseIndex = this.getEvictionStartIndex(criterias, removalSize);
        long criteriaValue = criterias[evictableBaseIndex];
        int evictedRecordCounter = 0;
        Iterator<Record> iterator = recordStore.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data key = record.getKey();
            long value = this.getEvictionCriteriaValue(record, evictionPolicy);
            if (value <= criteriaValue && this.tryEvict(key, record, recordStore, backup, now)) {
                ++evictedRecordCounter;
            }
            if (evictedRecordCounter < removalSize) continue;
            break;
        }
    }

    protected boolean isBackup(RecordStore recordStore) {
        int partitionId = recordStore.getPartitionId();
        InternalPartitionService partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
        InternalPartition partition = partitionService.getPartition(partitionId, false);
        return !partition.isLocal();
    }

    protected boolean tryEvict(Data key, Record record, RecordStore recordStore, boolean backup, long now) {
        Object value = record.getValue();
        if (recordStore.isLocked(key)) {
            return false;
        }
        recordStore.evict(key, backup);
        if (!backup) {
            boolean expired = recordStore.isExpired(record, now, false);
            recordStore.doPostEvictionOperations(key, value, expired);
        }
        return true;
    }

    protected long[] createAndPopulateEvictionCriteriaArray(RecordStore recordStore, EvictionPolicy evictionPolicy) {
        int size = recordStore.size();
        long[] criterias = null;
        int index = 0;
        Iterator<Record> iterator = recordStore.iterator();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            if (criterias == null) {
                criterias = new long[size];
            }
            criterias[index] = this.getEvictionCriteriaValue(record, evictionPolicy);
            if (++index != size) continue;
            break;
        }
        if (criterias == null) {
            return null;
        }
        if (index < criterias.length) {
            for (int i = index; i < criterias.length; ++i) {
                criterias[i] = Long.MAX_VALUE;
            }
        }
        return criterias;
    }

    protected int getEvictionStartIndex(long[] criterias, int evictableSize) {
        int length = criterias.length;
        int sizeToEvict = Math.min(evictableSize, length);
        int index = sizeToEvict - 1;
        return index < 0 ? 0 : index;
    }

    @Override
    public int findRemovalSize(RecordStore recordStore) {
        int removalSize;
        MapConfig mapConfig = recordStore.getMapContainer().getMapConfig();
        int maxSize = mapConfig.getMaxSizeConfig().getSize();
        int currentPartitionSize = recordStore.size();
        MaxSizeConfig.MaxSizePolicy maxSizePolicy = mapConfig.getMaxSizeConfig().getMaxSizePolicy();
        int evictionPercentage = mapConfig.getEvictionPercentage();
        switch (maxSizePolicy) {
            case PER_PARTITION: {
                int targetSizePerPartition = Double.valueOf((double)maxSize * ((double)(100 - evictionPercentage) / 100.0)).intValue();
                int diffFromTargetSize = currentPartitionSize - targetSizePerPartition;
                int prunedSize = currentPartitionSize * evictionPercentage / 100 + 1;
                removalSize = Math.max(diffFromTargetSize, prunedSize);
                break;
            }
            case PER_NODE: {
                int memberCount = this.mapServiceContext.getNodeEngine().getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR);
                int maxPartitionSize = maxSize * memberCount / this.mapServiceContext.getNodeEngine().getPartitionService().getPartitionCount();
                int targetSizePerPartition = Double.valueOf((double)maxPartitionSize * ((double)(100 - evictionPercentage) / 100.0)).intValue();
                int diffFromTargetSize = currentPartitionSize - targetSizePerPartition;
                int prunedSize = currentPartitionSize * evictionPercentage / 100 + 1;
                removalSize = Math.max(diffFromTargetSize, prunedSize);
                break;
            }
            case USED_HEAP_PERCENTAGE: 
            case USED_HEAP_SIZE: 
            case FREE_HEAP_PERCENTAGE: 
            case FREE_HEAP_SIZE: {
                removalSize = Math.max(currentPartitionSize * evictionPercentage / 100, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Max size policy is not defined [" + (Object)((Object)maxSizePolicy) + "]");
            }
        }
        return removalSize;
    }

    protected long getEvictionCriteriaValue(Record record, EvictionPolicy evictionPolicy) {
        long value;
        switch (evictionPolicy) {
            case LRU: 
            case LFU: {
                value = record.getEvictionCriteriaNumber();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + (Object)((Object)evictionPolicy) + ']');
            }
        }
        return value;
    }
}

