/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.event;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapPartitionLostEventFilter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.SyntheticEventFilter;
import com.hazelcast.map.impl.event.EntryEventData;
import com.hazelcast.map.impl.event.MapEventData;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.event.MapPartitionEventData;
import com.hazelcast.map.impl.query.QueryEventFilter;
import com.hazelcast.map.impl.wan.MapReplicationRemove;
import com.hazelcast.map.impl.wan.MapReplicationUpdate;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.Extractors;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.wan.ReplicationEventObject;
import com.hazelcast.wan.WanReplicationPublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class MapEventPublisherImpl
implements MapEventPublisher {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final SerializationService serializationService;
    protected final EventService eventService;

    public MapEventPublisherImpl(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = this.nodeEngine.getSerializationService();
        this.eventService = this.nodeEngine.getEventService();
    }

    @Override
    public void publishWanReplicationUpdate(String mapName, EntryView entryView) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        MapReplicationUpdate replicationEvent = new MapReplicationUpdate(mapName, mapContainer.getWanMergePolicy(), entryView);
        mapContainer.getWanReplicationPublisher().publishReplicationEvent("hz:impl:mapService", replicationEvent);
    }

    @Override
    public void publishWanReplicationRemove(String mapName, Data key, long removeTime) {
        MapReplicationRemove event = new MapReplicationRemove(mapName, key, removeTime);
        this.publishWanReplicationEventInternal(mapName, event);
    }

    @Override
    public void publishWanReplicationUpdateBackup(String mapName, EntryView entryView) {
    }

    @Override
    public void publishWanReplicationRemoveBackup(String mapName, Data key, long removeTime) {
    }

    @Override
    public void publishMapEvent(Address caller, String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        Collection<EventRegistration> mapsListenerRegistrations = this.getRegistrations(mapName);
        if (CollectionUtil.isEmpty(mapsListenerRegistrations)) {
            return;
        }
        ArrayList<EventRegistration> registrations = null;
        for (EventRegistration registration : mapsListenerRegistrations) {
            EventFilter filter = registration.getFilter();
            if (filter instanceof EventListenerFilter && !filter.eval(eventType.getType()) || filter instanceof MapPartitionLostEventFilter) continue;
            if (registrations == null) {
                registrations = new ArrayList<EventRegistration>();
            }
            registrations.add(registration);
        }
        if (CollectionUtil.isEmpty(registrations)) {
            return;
        }
        String source = this.getThisNodesAddress();
        MapEventData mapEventData = new MapEventData(source, mapName, caller, eventType.getType(), numberOfEntriesAffected);
        this.publishEventInternal(registrations, mapEventData, mapName.hashCode());
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, Data dataKey, Data dataOldValue, Data dataValue) {
        this.publishEvent(caller, mapName, eventType, false, dataKey, dataOldValue, dataValue);
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, boolean syntheticEvent, Data dataKey, Data dataOldValue, Data dataValue) {
        this.publishEvent(caller, mapName, eventType, syntheticEvent, dataKey, dataOldValue, dataValue, null);
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, boolean syntheticEvent, Data dataKey, Data dataOldValue, Data dataValue, Data dataMergingValue) {
        EntryEventData eventData;
        Collection<EventRegistration> registrations = this.getRegistrations(mapName);
        if (CollectionUtil.isEmpty(registrations)) {
            return;
        }
        List<EventRegistration> includeValueRegistrations = null;
        List<EventRegistration> nullValueRegistrations = null;
        for (EventRegistration registration : registrations) {
            EventFilter filter = registration.getFilter();
            if (!this.doFilter(filter, syntheticEvent, dataKey, dataOldValue, dataValue, eventType, mapName)) continue;
            if (this.isIncludeValue(filter)) {
                includeValueRegistrations = this.getOrCreateList(includeValueRegistrations);
                includeValueRegistrations.add(registration);
                continue;
            }
            nullValueRegistrations = this.getOrCreateList(nullValueRegistrations);
            nullValueRegistrations.add(registration);
        }
        if (!CollectionUtil.isEmpty(includeValueRegistrations)) {
            eventData = this.createEntryEventData(mapName, caller, dataKey, dataValue, dataOldValue, dataMergingValue, eventType.getType());
            int orderKey = this.pickOrderKey(dataKey);
            this.publishEventInternal(includeValueRegistrations, eventData, orderKey);
        }
        if (!CollectionUtil.isEmpty(nullValueRegistrations)) {
            eventData = this.createEntryEventData(mapName, caller, dataKey, null, null, null, eventType.getType());
            int orderKey = this.pickOrderKey(dataKey);
            this.publishEventInternal(nullValueRegistrations, eventData, orderKey);
        }
    }

    protected List<EventRegistration> getOrCreateList(List<EventRegistration> registrations) {
        if (registrations == null) {
            registrations = new ArrayList<EventRegistration>();
        }
        return registrations;
    }

    protected boolean doFilter(EventFilter filter, boolean syntheticEvent, Data dataKey, Data dataOldValue, Data dataValue, EntryEventType eventType, String mapNameOrNull) {
        if (filter instanceof MapPartitionLostEventFilter) {
            return false;
        }
        if (filter instanceof EventListenerFilter) {
            if (!filter.eval(eventType.getType())) {
                return false;
            }
            filter = ((EventListenerFilter)filter).getEventFilter();
        }
        if (filter instanceof SyntheticEventFilter) {
            if (syntheticEvent) {
                return false;
            }
            filter = ((SyntheticEventFilter)filter).getFilter();
        }
        if (filter instanceof TrueEventFilter) {
            return true;
        }
        if (filter instanceof QueryEventFilter) {
            return this.processQueryEventFilter(filter, eventType, dataKey, dataOldValue, dataValue, mapNameOrNull);
        }
        if (filter instanceof EntryEventFilter) {
            return this.processEntryEventFilter(filter, dataKey);
        }
        throw new IllegalArgumentException("Unknown EventFilter type = [" + filter.getClass().getCanonicalName() + "]");
    }

    protected boolean isIncludeValue(EventFilter filter) {
        if (filter instanceof EventListenerFilter) {
            filter = ((EventListenerFilter)filter).getEventFilter();
        }
        if (filter instanceof SyntheticEventFilter) {
            filter = ((SyntheticEventFilter)filter).getFilter();
        }
        if (filter instanceof TrueEventFilter) {
            return true;
        }
        if (filter instanceof QueryEventFilter) {
            return ((QueryEventFilter)filter).isIncludeValue();
        }
        if (filter instanceof EntryEventFilter) {
            return ((EntryEventFilter)filter).isIncludeValue();
        }
        throw new IllegalArgumentException("Unknown EventFilter type = [" + filter.getClass().getCanonicalName() + "]");
    }

    @Override
    public void publishMapPartitionLostEvent(Address caller, String mapName, int partitionId) {
        LinkedList<EventRegistration> registrations = new LinkedList<EventRegistration>();
        for (EventRegistration registration : this.getRegistrations(mapName)) {
            if (!(registration.getFilter() instanceof MapPartitionLostEventFilter)) continue;
            registrations.add(registration);
        }
        if (registrations.isEmpty()) {
            return;
        }
        String thisNodesAddress = this.getThisNodesAddress();
        MapPartitionEventData eventData = new MapPartitionEventData(thisNodesAddress, mapName, caller, partitionId);
        this.publishEventInternal(registrations, eventData, partitionId);
    }

    @Override
    public void hintMapEvent(Address caller, String mapName, EntryEventType eventType, int numberOfEntriesAffected, int partitionId) {
    }

    protected Collection<EventRegistration> getRegistrations(String mapName) {
        return this.eventService.getRegistrations("hz:impl:mapService", mapName);
    }

    private int pickOrderKey(Data key) {
        return key == null ? -1 : key.hashCode();
    }

    protected void publishEventInternal(Collection<EventRegistration> registrations, Object eventData, int orderKey) {
        this.eventService.publishEvent("hz:impl:mapService", registrations, eventData, orderKey);
    }

    private String getThisNodesAddress() {
        Address thisAddress = this.nodeEngine.getThisAddress();
        return thisAddress.toString();
    }

    private boolean processEntryEventFilter(EventFilter filter, Data dataKey) {
        EntryEventFilter eventFilter = (EntryEventFilter)filter;
        return eventFilter.eval(dataKey);
    }

    private boolean processQueryEventFilter(EventFilter filter, EntryEventType eventType, Data dataKey, Data dataOldValue, Data dataValue, String mapNameOrNull) {
        Data testValue = eventType == EntryEventType.REMOVED || eventType == EntryEventType.EVICTED || eventType == EntryEventType.EXPIRED ? dataOldValue : dataValue;
        Extractors extractors = this.getExtractorsForMapName(mapNameOrNull);
        QueryEventFilter queryEventFilter = (QueryEventFilter)filter;
        CachedQueryEntry entry = new CachedQueryEntry(this.serializationService, dataKey, testValue, extractors);
        return queryEventFilter.eval(entry);
    }

    private Extractors getExtractorsForMapName(String mapName) {
        if (mapName == null) {
            return Extractors.empty();
        }
        return this.mapServiceContext.getExtractors(mapName);
    }

    protected void publishWanReplicationEventInternal(String mapName, ReplicationEventObject event) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        WanReplicationPublisher wanReplicationPublisher = mapContainer.getWanReplicationPublisher();
        wanReplicationPublisher.publishReplicationEvent("hz:impl:mapService", event);
    }

    private EntryEventData createEntryEventData(String mapName, Address caller, Data dataKey, Data dataNewValue, Data dataOldValue, Data dataMergingValue, int eventType) {
        String thisNodesAddress = this.getThisNodesAddress();
        return new EntryEventData(thisNodesAddress, mapName, caller, dataKey, dataNewValue, dataOldValue, dataMergingValue, eventType);
    }
}

