/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.client.MapKeyBasedClientRequest;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MapGetRequest
extends MapKeyBasedClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private Data key;
    private boolean async;
    private transient long startTime;
    private long threadId;

    public MapGetRequest() {
    }

    public MapGetRequest(String name, Data key) {
        super(name);
        this.key = key;
    }

    public MapGetRequest(String name, Data key, long threadId) {
        super(name);
        this.key = key;
        this.threadId = threadId;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        MapOperation operation = this.getOperationProvider().createGetOperation(this.name, this.key);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(this.name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementGets(latency);
        }
    }

    public void setAsAsync() {
        this.async = true;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("a", this.async);
        writer.writeLong("threadId", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.async = reader.readBoolean("a");
        this.threadId = reader.readLong("threadId");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    public MapPermission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        if (this.async) {
            return "getAsync";
        }
        return "get";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }
}

