/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.operation.MergeOperation;
import com.hazelcast.map.impl.wan.MapReplicationRemove;
import com.hazelcast.map.impl.wan.MapReplicationUpdate;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ReplicationSupportingService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.wan.WanReplicationEvent;

class MapReplicationSupportingService
implements ReplicationSupportingService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public MapReplicationSupportingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent replicationEvent) {
        Object eventObject = replicationEvent.getEventObject();
        if (eventObject instanceof MapReplicationUpdate) {
            this.handleUpdate((MapReplicationUpdate)eventObject);
        } else if (eventObject instanceof MapReplicationRemove) {
            this.handleRemove((MapReplicationRemove)eventObject);
        }
    }

    private void handleRemove(MapReplicationRemove replicationRemove) {
        String mapName = replicationRemove.getMapName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        MapOperation operation = operationProvider.createWanOriginatedDeleteOperation(replicationRemove.getMapName(), replicationRemove.getKey());
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationRemove.getKey());
            InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void handleUpdate(MapReplicationUpdate replicationUpdate) {
        EntryView entryView = replicationUpdate.getEntryView();
        MapMergePolicy mergePolicy = replicationUpdate.getMergePolicy();
        String mapName = replicationUpdate.getMapName();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        MergeOperation operation = new MergeOperation(mapName, this.mapServiceContext.toData(entryView.getKey(), mapContainer.getPartitioningStrategy()), entryView, mergePolicy);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(entryView.getKey());
            InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

