/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.proxy.NearCachedMapProxyImpl;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import java.util.Map;

class MapRemoteService
implements RemoteService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        MapConfig mapConfig = this.nodeEngine.getConfig().findMapConfig(name);
        if (mapConfig.isNearCacheEnabled()) {
            return new NearCachedMapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine);
        }
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String name) {
        Map<String, MapContainer> mapContainers = this.mapServiceContext.getMapContainers();
        MapContainer mapContainer = mapContainers.remove(name);
        if (mapContainer != null) {
            if (mapContainer.isNearCacheEnabled()) {
                this.mapServiceContext.getNearCacheProvider().remove(name);
            }
            mapContainer.getMapStoreContext().stop();
        }
        this.mapServiceContext.destroyMap(name);
        this.nodeEngine.getEventService().deregisterAllListeners("hz:impl:mapService", name);
    }
}

