/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.IFunction;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.SizeEstimators;
import com.hazelcast.map.impl.eviction.EvictionCheckerImpl;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.EvictorImpl;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreContextFactory;
import com.hazelcast.map.impl.query.QueryEntryFactory;
import com.hazelcast.map.impl.record.DataRecordFactory;
import com.hazelcast.map.impl.record.ObjectRecordFactory;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Extractors;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapContainer {
    protected final String name;
    protected final String quorumName;
    protected final MapServiceContext mapServiceContext;
    protected final Map<String, MapInterceptor> interceptorMap;
    protected final Indexes indexes;
    protected final Extractors extractors;
    protected final SizeEstimator nearCacheSizeEstimator;
    protected final PartitioningStrategy partitioningStrategy;
    protected final MapStoreContext mapStoreContext;
    protected final SerializationService serializationService;
    protected final QueryEntryFactory queryEntryFactory;
    protected final List<MapInterceptor> interceptors;
    protected final IFunction<Object, Data> toDataFunction = new IFunction<Object, Data>(){

        @Override
        public Data apply(Object input) {
            SerializationService ss = MapContainer.this.mapStoreContext.getSerializationService();
            return ss.toData(input, MapContainer.this.partitioningStrategy);
        }
    };
    protected WanReplicationPublisher wanReplicationPublisher;
    protected ConstructorFunction<Void, RecordFactory> recordFactoryConstructor;
    protected MapMergePolicy wanMergePolicy;
    protected Evictor evictor;
    protected volatile MapConfig mapConfig;

    public MapContainer(String name, MapConfig mapConfig, MapServiceContext mapServiceContext) {
        this.name = name;
        this.mapConfig = mapConfig;
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.quorumName = mapConfig.getQuorumName();
        this.serializationService = nodeEngine.getSerializationService();
        this.recordFactoryConstructor = this.createRecordFactoryConstructor(this.serializationService);
        this.queryEntryFactory = new QueryEntryFactory(mapConfig.isOptimizeQueries());
        this.initWanReplication(nodeEngine);
        this.interceptors = new CopyOnWriteArrayList<MapInterceptor>();
        this.interceptorMap = new ConcurrentHashMap<String, MapInterceptor>();
        this.nearCacheSizeEstimator = SizeEstimators.createNearCacheSizeEstimator(mapConfig.getNearCacheConfig());
        this.mapStoreContext = MapStoreContextFactory.createMapStoreContext(this);
        this.mapStoreContext.start();
        this.extractors = new Extractors(mapConfig.getMapAttributeConfigs());
        this.indexes = new Indexes(this.serializationService, this.extractors);
        this.evictor = this.createEvictor(mapServiceContext);
    }

    Evictor createEvictor(MapServiceContext mapServiceContext) {
        EvictionCheckerImpl evictionChecker = new EvictionCheckerImpl(mapServiceContext);
        return new EvictorImpl(evictionChecker, mapServiceContext);
    }

    ConstructorFunction<Void, RecordFactory> createRecordFactoryConstructor(final SerializationService serializationService) {
        return new ConstructorFunction<Void, RecordFactory>(){

            @Override
            public RecordFactory createNew(Void notUsedArg) {
                RecordFactory<Object> recordFactory;
                switch (MapContainer.this.mapConfig.getInMemoryFormat()) {
                    case BINARY: {
                        recordFactory = new DataRecordFactory(MapContainer.this.mapConfig, serializationService, MapContainer.this.partitioningStrategy);
                        break;
                    }
                    case OBJECT: {
                        recordFactory = new ObjectRecordFactory(MapContainer.this.mapConfig, serializationService);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)MapContainer.this.mapConfig.getInMemoryFormat()));
                    }
                }
                return recordFactory;
            }
        };
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationPublisher = wanReplicationService.getWanReplicationPublisher(wanReplicationRefName);
        this.wanMergePolicy = this.mapServiceContext.getMergePolicyProvider().getMergePolicy(wanReplicationRef.getMergePolicy());
    }

    private PartitioningStrategy createPartitioningStrategy() {
        PartitioningStrategy strategy = null;
        PartitioningStrategyConfig partitioningStrategyConfig = this.mapConfig.getPartitioningStrategyConfig();
        if (partitioningStrategyConfig != null && (strategy = partitioningStrategyConfig.getPartitioningStrategy()) == null && partitioningStrategyConfig.getPartitioningStrategyClass() != null) {
            try {
                strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.mapServiceContext.getNodeEngine().getConfigClassLoader(), partitioningStrategyConfig.getPartitioningStrategyClass());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return strategy;
    }

    public Indexes getIndexes() {
        return this.indexes;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public void addInterceptor(String id, MapInterceptor interceptor) {
        this.removeInterceptor(id);
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
    }

    public List<MapInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, MapInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public void removeInterceptor(String id) {
        MapInterceptor interceptor = this.interceptorMap.remove(id);
        this.interceptors.remove(interceptor);
    }

    public boolean isWanReplicationEnabled() {
        return this.wanReplicationPublisher != null && this.wanMergePolicy != null;
    }

    public boolean isNearCacheEnabled() {
        return this.mapConfig.isNearCacheEnabled();
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public MapStoreContext getMapStoreContext() {
        return this.mapStoreContext;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getQuorumName() {
        return this.quorumName;
    }

    public IFunction<Object, Data> toData() {
        return this.toDataFunction;
    }

    public ConstructorFunction<Void, RecordFactory> getRecordFactoryConstructor() {
        return this.recordFactoryConstructor;
    }

    public QueryableEntry newQueryEntry(Data key, Object value) {
        return this.queryEntryFactory.newEntry(this.serializationService, key, value, this.extractors);
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    public void setEvictor(Evictor evictor) {
        this.evictor = evictor;
    }

    Extractors getExtractors() {
        return this.extractors;
    }
}

