/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class LazyMapEntry
implements Map.Entry,
Serializable {
    private static final long serialVersionUID = 0L;
    private transient Object keyObject;
    private transient Object valueObject;
    private transient Data keyData;
    private transient Data valueData;
    private transient boolean modified;
    private transient SerializationService serializationService;

    public LazyMapEntry() {
    }

    public LazyMapEntry(Object key, Object value, SerializationService serializationService) {
        this.init(key, value, serializationService);
    }

    public void init(Object key, Object value, SerializationService serializationService) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Preconditions.checkNotNull(serializationService, "SerializationService cannot be null");
        this.keyData = null;
        this.keyObject = null;
        if (key instanceof Data) {
            this.keyData = (Data)key;
        } else {
            this.keyObject = key;
        }
        this.valueData = null;
        this.valueObject = null;
        if (value instanceof Data) {
            this.valueData = (Data)value;
        } else {
            this.valueObject = value;
        }
        this.serializationService = serializationService;
    }

    public Object getKey() {
        if (this.keyObject == null) {
            this.keyObject = this.serializationService.toObject(this.keyData);
        }
        return this.keyObject;
    }

    public Object getValue() {
        if (this.valueObject == null) {
            this.valueObject = this.serializationService.toObject(this.valueData);
        }
        return this.valueObject;
    }

    public Object setValue(Object value) {
        this.modified = true;
        Object oldValue = this.getValue();
        this.valueObject = value;
        this.valueData = null;
        return oldValue;
    }

    public Object getKeyData() {
        if (this.keyData == null) {
            this.keyData = this.serializationService.toData(this.keyObject);
        }
        return this.keyData;
    }

    public Object getValueData() {
        if (this.valueData == null) {
            this.valueData = this.serializationService.toData(this.valueObject);
        }
        return this.valueData;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return LazyMapEntry.equals(this.getKey(), e.getKey()) && LazyMapEntry.equals(this.getValue(), e.getValue());
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keyObject = s.readObject();
        this.valueObject = s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getKey());
        s.writeObject(this.getValue());
    }
}

