/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggerFactorySupport;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jFactory
extends LoggerFactorySupport
implements LoggerFactory {
    @Override
    protected ILogger createLogger(String name) {
        Logger l = Logger.getLogger((String)name);
        return new Log4jLogger(l);
    }

    static class Log4jLogger
    extends AbstractLogger {
        private final Logger logger;
        private final Level level;

        public Log4jLogger(Logger logger) {
            this.logger = logger;
            org.apache.log4j.Level log4jLevel = logger.getLevel();
            this.level = log4jLevel == org.apache.log4j.Level.DEBUG ? Level.FINEST : (log4jLevel == org.apache.log4j.Level.INFO ? Level.INFO : (log4jLevel == org.apache.log4j.Level.WARN ? Level.WARNING : (log4jLevel == org.apache.log4j.Level.FATAL ? Level.SEVERE : (log4jLevel == org.apache.log4j.Level.OFF ? Level.OFF : Level.INFO))));
        }

        @Override
        public void log(Level level, String message) {
            if (Level.FINEST == level) {
                this.logger.debug((Object)message);
            } else if (Level.SEVERE == level) {
                this.logger.fatal((Object)message);
            } else if (Level.WARNING == level) {
                this.logger.warn((Object)message);
            } else if (level != Level.OFF) {
                this.logger.info((Object)message);
            }
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public boolean isLoggable(Level level) {
            if (Level.OFF == level) {
                return false;
            }
            if (Level.FINEST == level) {
                return this.logger.isDebugEnabled();
            }
            if (Level.WARNING == level) {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
            }
            if (Level.SEVERE == level) {
                return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.FATAL);
            }
            if (Level.OFF == level) {
                return false;
            }
            return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.INFO);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            if (Level.FINEST == level) {
                this.logger.debug((Object)message, thrown);
            } else if (Level.WARNING == level) {
                this.logger.warn((Object)message, thrown);
            } else if (Level.SEVERE == level) {
                this.logger.fatal((Object)message, thrown);
            } else if (Level.OFF != level) {
                this.logger.info((Object)message, thrown);
            }
        }

        @Override
        public void log(LogEvent logEvent) {
            org.apache.log4j.Level level;
            LogRecord logRecord = logEvent.getLogRecord();
            String name = logEvent.getLogRecord().getLoggerName();
            Logger logger = Logger.getLogger((String)name);
            if (logRecord.getLevel() == Level.FINEST) {
                level = org.apache.log4j.Level.DEBUG;
            } else if (logRecord.getLevel() == Level.INFO) {
                level = org.apache.log4j.Level.INFO;
            } else if (logRecord.getLevel() == Level.WARNING) {
                level = org.apache.log4j.Level.WARN;
            } else if (logRecord.getLevel() == Level.SEVERE) {
                level = org.apache.log4j.Level.FATAL;
            } else {
                if (logRecord.getLevel() == Level.OFF) {
                    return;
                }
                level = org.apache.log4j.Level.INFO;
            }
            String message = logRecord.getMessage();
            Throwable throwable = logRecord.getThrown();
            logger.callAppenders(new LoggingEvent(name, (Category)logger, (Priority)level, (Object)message, throwable));
        }
    }
}

