/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactorySupport;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4j2Factory
extends LoggerFactorySupport {
    private static final String FQCN = Log4j2Logger.class.getName();

    @Override
    protected ILogger createLogger(String name) {
        return new Log4j2Logger(LogManager.getContext().getLogger(name));
    }

    class Log4j2Logger
    extends AbstractLogger {
        private final ExtendedLogger logger;

        public Log4j2Logger(ExtendedLogger logger) {
            this.logger = logger;
        }

        @Override
        public void log(LogEvent logEvent) {
            LogRecord logRecord = logEvent.getLogRecord();
            java.util.logging.Level level = logEvent.getLogRecord().getLevel();
            String message = logRecord.getMessage();
            Throwable thrown = logRecord.getThrown();
            this.log(level, message, thrown);
        }

        @Override
        public void log(java.util.logging.Level level, String message) {
            this.logger.logIfEnabled(FQCN, this.getLevel(level), null, message);
        }

        @Override
        public void log(java.util.logging.Level level, String message, Throwable thrown) {
            this.logger.logIfEnabled(FQCN, this.getLevel(level), null, message, thrown);
        }

        @Override
        public java.util.logging.Level getLevel() {
            if (this.logger.isDebugEnabled()) {
                return java.util.logging.Level.FINEST;
            }
            if (this.logger.isInfoEnabled()) {
                return java.util.logging.Level.INFO;
            }
            if (this.logger.isWarnEnabled()) {
                return java.util.logging.Level.WARNING;
            }
            if (this.logger.isFatalEnabled()) {
                return java.util.logging.Level.SEVERE;
            }
            return java.util.logging.Level.OFF;
        }

        @Override
        public boolean isLoggable(java.util.logging.Level level) {
            if (java.util.logging.Level.OFF == level) {
                return false;
            }
            return this.logger.isEnabled(this.getLevel(level), null);
        }

        private Level getLevel(java.util.logging.Level level) {
            if (java.util.logging.Level.SEVERE == level) {
                return Level.ERROR;
            }
            if (java.util.logging.Level.WARNING == level) {
                return Level.WARN;
            }
            if (java.util.logging.Level.INFO == level) {
                return Level.INFO;
            }
            if (java.util.logging.Level.CONFIG == level) {
                return Level.INFO;
            }
            if (java.util.logging.Level.FINE == level) {
                return Level.DEBUG;
            }
            if (java.util.logging.Level.FINER == level) {
                return Level.DEBUG;
            }
            if (java.util.logging.Level.FINEST == level) {
                return Level.DEBUG;
            }
            if (java.util.logging.Level.OFF == level) {
                return Level.OFF;
            }
            return Level.INFO;
        }
    }
}

