/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.jclouds.ComputeServiceBuilder;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.jclouds.compute.domain.NodeMetadata;

public class JCloudsDiscoveryStrategy
implements DiscoveryStrategy {
    private final ComputeServiceBuilder computeServiceBuilder;

    public JCloudsDiscoveryStrategy(Map<String, Comparable> properties) {
        this.computeServiceBuilder = new ComputeServiceBuilder(properties);
    }

    @Override
    public void start() {
        this.computeServiceBuilder.build();
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>();
        try {
            Iterable<? extends NodeMetadata> nodes = this.computeServiceBuilder.getFilteredNodes();
            for (NodeMetadata nodeMetadata : nodes) {
                if (nodeMetadata.getStatus() != NodeMetadata.Status.RUNNING) continue;
                discoveryNodes.add(this.buildDiscoveredNode(nodeMetadata));
            }
        }
        catch (Exception e) {
            throw new HazelcastException("Failed to get registered addresses", e);
        }
        return discoveryNodes;
    }

    @Override
    public void destroy() {
        this.computeServiceBuilder.destroy();
    }

    private DiscoveryNode buildDiscoveredNode(NodeMetadata metadata) {
        Address privateAddressInstance = null;
        if (!metadata.getPrivateAddresses().isEmpty()) {
            InetAddress privateAddress = this.mapAddress((String)metadata.getPrivateAddresses().iterator().next());
            privateAddressInstance = new Address(privateAddress, this.computeServiceBuilder.getServicePort());
        }
        Address publicAddressInstance = null;
        if (!metadata.getPublicAddresses().isEmpty()) {
            InetAddress publicAddress = this.mapAddress((String)metadata.getPublicAddresses().iterator().next());
            publicAddressInstance = new Address(publicAddress, this.computeServiceBuilder.getServicePort());
        }
        return new SimpleDiscoveryNode(privateAddressInstance, publicAddressInstance);
    }

    private InetAddress mapAddress(String address) {
        if (address == null) {
            return null;
        }
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new InvalidConfigurationException("Address '" + address + "' could not be resolved");
        }
    }
}

