/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds;

import com.hazelcast.config.InvalidConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.aws.domain.SessionCredentials;

public class IAMRoleCredentialSupplierBuilder {
    private static final String IAM_ROLE_ENDPOINT = "169.254.169.254";
    private String roleName;
    private SessionCredentials credentials;

    public IAMRoleCredentialSupplierBuilder withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    private Map<String, String> getKeysFromIamRole() {
        try {
            String query = "latest/meta-data/iam/security-credentials/" + this.roleName;
            URL url = new URL("http", IAM_ROLE_ENDPOINT, query);
            InputStreamReader is = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader reader = new BufferedReader(is);
            Map<String, String> map = this.parseIamRole(reader);
            return map;
        }
        catch (IOException io) {
            throw new InvalidConfigurationException("Invalid Aws Configuration");
        }
    }

    private Map<String, String> parseIamRole(BufferedReader reader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern keyPattern = Pattern.compile("\"(.*?)\" : ");
        Pattern valuePattern = Pattern.compile(" : \"(.*?)\",");
        String line = reader.readLine();
        while (line != null) {
            if (line.contains(":")) {
                Matcher keyMatcher = keyPattern.matcher(line);
                Matcher valueMatcher = valuePattern.matcher(line);
                if (keyMatcher.find() && valueMatcher.find()) {
                    String key = keyMatcher.group(1);
                    String value = valueMatcher.group(1);
                    map.put(key, value);
                }
            }
            line = reader.readLine();
        }
        return map;
    }

    public SessionCredentials build() {
        Map<String, String> keyMaps = this.getKeysFromIamRole();
        this.credentials = new SessionCredentials.Builder().accessKeyId(keyMaps.get("AccessKeyId")).secretAccessKey(keyMaps.get("SecretAccessKey")).sessionToken(keyMaps.get("Token")).build();
        return this.credentials;
    }
}

