/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.io.Files;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.jclouds.IAMRoleCredentialSupplierBuilder;
import com.hazelcast.jclouds.JCloudsProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.googlecloud.GoogleCredentialsFromJson;

public class ComputeServiceBuilder {
    private static final String GOOGLE_COMPUTE_ENGINE = "google-compute-engine";
    private static final String AWS_EC2 = "aws-ec2";
    private static final String JCLOUD_CONNECTION_TIMEOUT = "10000";
    private static final ILogger LOGGER = Logger.getLogger(ComputeServiceBuilder.class);
    private final Map<String, Comparable> properties;
    private Set<String> regionsSet = new LinkedHashSet<String>();
    private Set<String> zonesSet = new LinkedHashSet<String>();
    private List<AbstractMap.SimpleImmutableEntry> tagPairs = new ArrayList<AbstractMap.SimpleImmutableEntry>();
    private Predicate<ComputeMetadata> nodesFilter;
    private ComputeService computeService;

    ComputeServiceBuilder(Map<String, Comparable> properties) {
        Preconditions.checkNotNull(properties, "Props cannot be null");
        this.properties = properties;
    }

    public Iterable<? extends NodeMetadata> getFilteredNodes() {
        String group = (String)this.getOrNull(JCloudsProperties.GROUP);
        Set result = this.computeService.listNodesDetailsMatching(this.nodesFilter);
        HashSet<NodeMetadata> filteredResult = new HashSet<NodeMetadata>();
        for (NodeMetadata metadata : result) {
            if (group != null && !group.equals(metadata.getGroup()) || this.checkRegionZoneConfig(metadata)) continue;
            filteredResult.add(metadata);
        }
        return filteredResult;
    }

    public int getServicePort() {
        return this.getOrDefault(JCloudsProperties.HZ_PORT, 5701);
    }

    private boolean checkRegionZoneConfig(NodeMetadata metadata) {
        block4: for (Location location = metadata.getLocation(); location != null; location = location.getParent()) {
            String id = location.getId();
            switch (location.getScope()) {
                case ZONE: {
                    if (id == null || !this.regionsSet.contains(id)) continue block4;
                    return true;
                }
                case REGION: {
                    if (id == null || this.zonesSet.contains(id)) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public void destroy() {
        if (this.computeService != null) {
            this.computeService.getContext().close();
        }
    }

    ComputeService build() {
        String cloudProvider = (String)this.getOrNull(JCloudsProperties.PROVIDER);
        String identity = (String)this.getOrNull(JCloudsProperties.IDENTITY);
        String credential = (String)this.getOrNull(JCloudsProperties.CREDENTIAL);
        String credentialPath = (String)this.getOrNull(JCloudsProperties.CREDENTIAL_PATH);
        Preconditions.checkNotNull(cloudProvider, "Cloud provider is not set");
        if (credential != null && credentialPath != null) {
            throw new UnsupportedOperationException("Both credential and credentialPath are set. Use only one method.");
        }
        if (credentialPath != null) {
            credential = this.getCredentialFromFile(credential, credentialPath);
        }
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest("Using CLOUD_PROVIDER: " + cloudProvider);
        }
        String roleName = (String)this.getOrNull(JCloudsProperties.ROLE_NAME);
        ContextBuilder contextBuilder = this.newContextBuilder(cloudProvider, identity, credential, roleName);
        Properties jcloudsProperties = this.buildRegionZonesConfig();
        this.buildTagConfig();
        this.buildNodeFilter();
        this.computeService = ((ComputeServiceContext)contextBuilder.overrides(jcloudsProperties).buildView(ComputeServiceContext.class)).getComputeService();
        return this.computeService;
    }

    private Properties buildRegionZonesConfig() {
        String regions = (String)this.getOrNull(JCloudsProperties.REGIONS);
        String zones = (String)this.getOrNull(JCloudsProperties.ZONES);
        Properties jcloudsProperties = this.newOverrideProperties();
        if (regions != null) {
            jcloudsProperties.setProperty("jclouds.regions", regions);
        }
        if (zones != null) {
            jcloudsProperties.setProperty("jclouds.zones", zones);
            jcloudsProperties.setProperty("jclouds.regions", regions);
        }
        return jcloudsProperties;
    }

    private void buildTagConfig() {
        String tagKeys = (String)this.getOrNull(JCloudsProperties.TAG_KEYS);
        String tagValues = (String)this.getOrNull(JCloudsProperties.TAG_VALUES);
        if (tagKeys != null && tagValues != null) {
            List<String> keysList = Arrays.asList(tagKeys.split(","));
            List<String> valueList = Arrays.asList(tagValues.split(","));
            if (keysList.size() != valueList.size()) {
                throw new InvalidConfigurationException("Tags keys and value count does not match.");
            }
            for (int i = 0; i < keysList.size(); ++i) {
                this.tagPairs.add(new AbstractMap.SimpleImmutableEntry<String, String>(keysList.get(i), valueList.get(i)));
            }
        }
    }

    private void buildNodeFilter() {
        this.nodesFilter = new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata nodeMetadata) {
                if (nodeMetadata == null) {
                    return false;
                }
                for (AbstractMap.SimpleImmutableEntry entry : ComputeServiceBuilder.this.tagPairs) {
                    if (((String)nodeMetadata.getUserMetadata().get(entry.getKey())).equals(entry.getValue())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private String getCredentialFromFile(String provider, String credentialPath) throws IllegalArgumentException {
        try {
            String fileContents = Files.toString((File)new File(credentialPath), (Charset)Charsets.UTF_8);
            if (provider.equals(GOOGLE_COMPUTE_ENGINE)) {
                GoogleCredentialsFromJson credentialSupplier = new GoogleCredentialsFromJson(fileContents);
                return ((Credentials)credentialSupplier.get()).credential;
            }
            return fileContents;
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Failed to retrieve the private key from the file: " + credentialPath, e);
        }
    }

    private ContextBuilder newContextBuilder(String cloudProvider, String identity, String credential, final String roleName) {
        try {
            if (roleName != null && (identity != null || credential != null)) {
                throw new InvalidConfigurationException("IAM role is configured, identity or credential propery is not allowed.");
            }
            if (cloudProvider.equals(AWS_EC2) && roleName != null) {
                Supplier<Credentials> credentialsSupplier = new Supplier<Credentials>(){

                    public Credentials get() {
                        return new IAMRoleCredentialSupplierBuilder().withRoleName(roleName).build();
                    }
                };
                return ContextBuilder.newBuilder((String)cloudProvider).credentialsSupplier((Supplier)credentialsSupplier);
            }
            Preconditions.checkNotNull(identity, "Cloud provider identity is not set");
            Preconditions.checkNotNull(credential, "Cloud provider credential is not set");
            return ContextBuilder.newBuilder((String)cloudProvider).credentials(identity, credential);
        }
        catch (NoSuchElementException e) {
            throw new InvalidConfigurationException("Unrecognized cloud-provider [" + cloudProvider + "]");
        }
    }

    private Properties newOverrideProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.so-timeout", JCLOUD_CONNECTION_TIMEOUT);
        properties.setProperty("jclouds.connection-timeout", JCLOUD_CONNECTION_TIMEOUT);
        return properties;
    }

    private <T extends Comparable> T getOrNull(PropertyDefinition property) {
        return this.getOrDefault(property, null);
    }

    private <T extends Comparable> T getOrDefault(PropertyDefinition property, T defaultValue) {
        if (this.properties == null || property == null) {
            return defaultValue;
        }
        Comparable value = this.properties.get(property.key());
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }
}

