/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.ByteArraySerializerAdapter;
import com.hazelcast.internal.serialization.impl.SerializerAdapter;
import com.hazelcast.internal.serialization.impl.StreamSerializerAdapter;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.VersionedPortable;
import java.util.Collections;
import java.util.Set;

public final class SerializationUtil {
    public static final String PROP_DEFAULT_SERIALIZER_OVERRIDE = "hazelcast.serialization.default.serializer.override";
    static final int CONSTANT_SERIALIZERS_SIZE = 21;
    static final PartitioningStrategy EMPTY_PARTITIONING_STRATEGY = new PartitioningStrategy(){

        public Object getPartitionKey(Object key) {
            return null;
        }
    };
    private static boolean defaultSerializerOverride = Boolean.parseBoolean(System.getProperty("hazelcast.serialization.default.serializer.override", "false"));

    private SerializationUtil() {
    }

    public static boolean isDefaultSerializerOverride() {
        return defaultSerializerOverride;
    }

    static boolean isNullData(Data data) {
        return data.dataSize() == 0 && data.getType() == 0;
    }

    static RuntimeException handleException(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
            throw (Error)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof HazelcastSerializationException) {
            throw (HazelcastSerializationException)e;
        }
        throw new HazelcastSerializationException(e);
    }

    static SerializerAdapter createSerializerAdapter(Serializer serializer, SerializationService serializationService) {
        SerializerAdapter s;
        if (serializer instanceof StreamSerializer) {
            s = new StreamSerializerAdapter(serializationService, (StreamSerializer)serializer);
        } else if (serializer instanceof ByteArraySerializer) {
            s = new ByteArraySerializerAdapter((ByteArraySerializer)serializer);
        } else {
            throw new IllegalArgumentException("Serializer must be instance of either StreamSerializer or ByteArraySerializer!");
        }
        return s;
    }

    static void getInterfaces(Class clazz, Set<Class> interfaces) {
        Class<?>[] classes = clazz.getInterfaces();
        if (classes.length > 0) {
            Collections.addAll(interfaces, classes);
            for (Class<?> cl : classes) {
                SerializationUtil.getInterfaces(cl, interfaces);
            }
        }
    }

    static int indexForDefaultType(int typeId) {
        return -typeId - 1;
    }

    public static int getPortableVersion(Portable portable, int defaultVersion) {
        VersionedPortable versionedPortable;
        int version = defaultVersion;
        if (portable instanceof VersionedPortable && (version = (versionedPortable = (VersionedPortable)portable).getClassVersion()) < 0) {
            throw new IllegalArgumentException("Version cannot be negative!");
        }
        return version;
    }
}

