/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.internal.serialization.InputOutputFactory;
import com.hazelcast.internal.serialization.PortableContext;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.internal.serialization.impl.ArrayListStreamSerializer;
import com.hazelcast.internal.serialization.impl.ConstantSerializers;
import com.hazelcast.internal.serialization.impl.DataSerializer;
import com.hazelcast.internal.serialization.impl.JavaDefaultSerializers;
import com.hazelcast.internal.serialization.impl.LinkedListStreamSerializer;
import com.hazelcast.internal.serialization.impl.PortableContextImpl;
import com.hazelcast.internal.serialization.impl.PortableHookLoader;
import com.hazelcast.internal.serialization.impl.PortableSerializer;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactory;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SerializationServiceV1
extends AbstractSerializationService {
    private final PortableContextImpl portableContext;
    private final PortableSerializer portableSerializer;

    SerializationServiceV1(InputOutputFactory inputOutputFactory, byte version, int portableVersion, ClassLoader classLoader, Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, Map<Integer, ? extends PortableFactory> portableFactories, ManagedContext managedContext, PartitioningStrategy globalPartitionStrategy, int initialOutputBufferSize, BufferPoolFactory bufferPoolFactory) {
        super(inputOutputFactory, version, classLoader, managedContext, globalPartitionStrategy, initialOutputBufferSize, bufferPoolFactory);
        PortableHookLoader loader = new PortableHookLoader(portableFactories, classLoader);
        this.portableContext = new PortableContextImpl(this, portableVersion);
        for (ClassDefinition cd : loader.getDefinitions()) {
            this.portableContext.registerClassDefinition(cd);
        }
        this.dataSerializerAdapter = SerializationUtil.createSerializerAdapter(new DataSerializer(dataSerializableFactories, classLoader), this);
        this.portableSerializer = new PortableSerializer(this.portableContext, loader.getFactories());
        this.portableSerializerAdapter = SerializationUtil.createSerializerAdapter(this.portableSerializer, this);
        this.registerConstantSerializers();
    }

    @Override
    public PortableReader createPortableReader(Data data) throws IOException {
        if (!data.isPortable()) {
            throw new IllegalArgumentException("Given data is not Portable! -> " + data.getType());
        }
        BufferObjectDataInput in = this.createObjectDataInput(data);
        return this.portableSerializer.createReader(in);
    }

    @Override
    public PortableContext getPortableContext() {
        return this.portableContext;
    }

    protected void registerConstantSerializers() {
        this.registerConstant(DataSerializable.class, this.dataSerializerAdapter);
        this.registerConstant(Portable.class, this.portableSerializerAdapter);
        this.registerConstant(Byte.class, new ConstantSerializers.ByteSerializer());
        this.registerConstant(Boolean.class, new ConstantSerializers.BooleanSerializer());
        this.registerConstant(Character.class, new ConstantSerializers.CharSerializer());
        this.registerConstant(Short.class, new ConstantSerializers.ShortSerializer());
        this.registerConstant(Integer.class, new ConstantSerializers.IntegerSerializer());
        this.registerConstant(Long.class, new ConstantSerializers.LongSerializer());
        this.registerConstant(Float.class, new ConstantSerializers.FloatSerializer());
        this.registerConstant(Double.class, new ConstantSerializers.DoubleSerializer());
        this.registerConstant(String.class, new ConstantSerializers.StringSerializer());
        this.registerConstant(byte[].class, new ConstantSerializers.TheByteArraySerializer());
        this.registerConstant(boolean[].class, new ConstantSerializers.BooleanArraySerializer());
        this.registerConstant(char[].class, new ConstantSerializers.CharArraySerializer());
        this.registerConstant(short[].class, new ConstantSerializers.ShortArraySerializer());
        this.registerConstant(int[].class, new ConstantSerializers.IntegerArraySerializer());
        this.registerConstant(long[].class, new ConstantSerializers.LongArraySerializer());
        this.registerConstant(float[].class, new ConstantSerializers.FloatArraySerializer());
        this.registerConstant(double[].class, new ConstantSerializers.DoubleArraySerializer());
        this.registerConstant(String[].class, new ConstantSerializers.StringArraySerializer());
    }

    public void registerJavaTypeSerializers(boolean enableCompression, boolean enableSharedObject) {
        this.safeRegister(Date.class, new JavaDefaultSerializers.DateSerializer());
        this.safeRegister(BigInteger.class, new JavaDefaultSerializers.BigIntegerSerializer());
        this.safeRegister(BigDecimal.class, new JavaDefaultSerializers.BigDecimalSerializer());
        this.safeRegister(Externalizable.class, new JavaDefaultSerializers.ExternalizableSerializer(enableCompression));
        this.safeRegister(Serializable.class, new JavaDefaultSerializers.JavaSerializer(enableSharedObject, enableCompression));
        this.safeRegister(Class.class, new JavaDefaultSerializers.ClassSerializer());
        this.safeRegister(Enum.class, new JavaDefaultSerializers.EnumSerializer());
        this.safeRegister(ArrayList.class, new ArrayListStreamSerializer());
        this.safeRegister(LinkedList.class, new LinkedListStreamSerializer());
    }

    public void registerClassDefinitions(Collection<ClassDefinition> classDefinitions, boolean checkClassDefErrors) {
        HashMap<Integer, ClassDefinition> classDefMap = new HashMap<Integer, ClassDefinition>(classDefinitions.size());
        for (ClassDefinition cd : classDefinitions) {
            if (classDefMap.containsKey(cd.getClassId())) {
                throw new HazelcastSerializationException("Duplicate registration found for class-id[" + cd.getClassId() + "]!");
            }
            classDefMap.put(cd.getClassId(), cd);
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            this.registerClassDefinition(classDefinition, classDefMap, checkClassDefErrors);
        }
    }

    protected void registerClassDefinition(ClassDefinition cd, Map<Integer, ClassDefinition> classDefMap, boolean checkClassDefErrors) {
        Set<String> fieldNames = cd.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldDefinition fd = cd.getField(fieldName);
            if (fd.getType() != FieldType.PORTABLE && fd.getType() != FieldType.PORTABLE_ARRAY) continue;
            int classId = fd.getClassId();
            ClassDefinition nestedCd = classDefMap.get(classId);
            if (nestedCd != null) {
                this.registerClassDefinition(nestedCd, classDefMap, checkClassDefErrors);
                this.portableContext.registerClassDefinition(nestedCd);
                continue;
            }
            if (!checkClassDefErrors) continue;
            throw new HazelcastSerializationException("Could not find registered ClassDefinition for class-id: " + classId);
        }
        this.portableContext.registerClassDefinition(cd);
    }

    final PortableSerializer getPortableSerializer() {
        return this.portableSerializer;
    }
}

