/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.StreamSerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class JavaDefaultSerializers {
    private JavaDefaultSerializers() {
    }

    private static abstract class SingletonSerializer<T>
    implements StreamSerializer<T> {
        private SingletonSerializer() {
        }

        @Override
        public void destroy() {
        }
    }

    public static final class EnumSerializer
    extends SingletonSerializer<Enum> {
        @Override
        public int getTypeId() {
            return -106;
        }

        @Override
        public void write(ObjectDataOutput out, Enum obj) throws IOException {
            String name = obj.getDeclaringClass().getName();
            out.writeUTF(name);
            out.writeUTF(obj.name());
        }

        @Override
        public Enum read(ObjectDataInput in) throws IOException {
            Class<?> clazz;
            String clazzName = in.readUTF();
            try {
                clazz = ClassLoaderUtil.loadClass(in.getClassLoader(), clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException("Failed to deserialize enum: " + clazzName, e);
            }
            String name = in.readUTF();
            return Enum.valueOf(clazz, name);
        }
    }

    public static final class JavaSerializer
    extends SingletonSerializer<Object> {
        private final boolean shared;
        private final boolean gzipEnabled;

        public JavaSerializer(boolean shared, boolean gzipEnabled) {
            this.shared = shared;
            this.gzipEnabled = gzipEnabled;
        }

        @Override
        public int getTypeId() {
            return -104;
        }

        @Override
        public Object read(ObjectDataInput in) throws IOException {
            Object result;
            InputStream inputStream = (InputStream)((Object)in);
            ObjectInputStream objectInputStream = this.gzipEnabled ? IOUtil.newObjectInputStream(in.getClassLoader(), new GZIPInputStream(inputStream)) : IOUtil.newObjectInputStream(in.getClassLoader(), inputStream);
            try {
                result = this.shared ? objectInputStream.readObject() : objectInputStream.readUnshared();
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException(e);
            }
            return result;
        }

        @Override
        @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
        public void write(ObjectDataOutput out, Object obj) throws IOException {
            ObjectOutputStream objectOutputStream;
            OutputStream outputStream = (OutputStream)((Object)out);
            GZIPOutputStream gzip = null;
            if (this.gzipEnabled) {
                gzip = new GZIPOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream(gzip);
            } else {
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            if (this.shared) {
                objectOutputStream.writeObject(obj);
            } else {
                objectOutputStream.writeUnshared(obj);
            }
            objectOutputStream.flush();
            if (this.gzipEnabled) {
                gzip.finish();
            }
        }
    }

    public static final class ExternalizableSerializer
    extends SingletonSerializer<Externalizable> {
        private final boolean gzipEnabled;

        public ExternalizableSerializer(boolean gzipEnabled) {
            this.gzipEnabled = gzipEnabled;
        }

        @Override
        public int getTypeId() {
            return -105;
        }

        @Override
        public Externalizable read(ObjectDataInput in) throws IOException {
            String className = in.readUTF();
            try {
                Externalizable ds = (Externalizable)ClassLoaderUtil.newInstance(in.getClassLoader(), className);
                InputStream inputStream = (InputStream)((Object)in);
                ObjectInputStream objectInputStream = this.gzipEnabled ? IOUtil.newObjectInputStream(in.getClassLoader(), new GZIPInputStream(inputStream)) : IOUtil.newObjectInputStream(in.getClassLoader(), inputStream);
                ds.readExternal(objectInputStream);
                return ds;
            }
            catch (Exception e) {
                throw new HazelcastSerializationException("Problem while reading Externalizable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public void write(ObjectDataOutput out, Externalizable obj) throws IOException {
            ObjectOutputStream objectOutputStream;
            out.writeUTF(obj.getClass().getName());
            OutputStream outputStream = (OutputStream)((Object)out);
            GZIPOutputStream gzip = null;
            if (this.gzipEnabled) {
                gzip = new GZIPOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream(gzip);
            } else {
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            obj.writeExternal(objectOutputStream);
            objectOutputStream.flush();
            if (this.gzipEnabled) {
                gzip.finish();
            }
        }
    }

    public static final class ClassSerializer
    extends SingletonSerializer<Class> {
        @Override
        public int getTypeId() {
            return -100;
        }

        @Override
        public Class read(ObjectDataInput in) throws IOException {
            try {
                return ClassLoaderUtil.loadClass(in.getClassLoader(), in.readUTF());
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException(e);
            }
        }

        @Override
        public void write(ObjectDataOutput out, Class obj) throws IOException {
            out.writeUTF(obj.getName());
        }
    }

    public static final class DateSerializer
    extends SingletonSerializer<Date> {
        @Override
        public int getTypeId() {
            return -101;
        }

        @Override
        public Date read(ObjectDataInput in) throws IOException {
            return new Date(in.readLong());
        }

        @Override
        public void write(ObjectDataOutput out, Date obj) throws IOException {
            out.writeLong(obj.getTime());
        }
    }

    public static final class BigDecimalSerializer
    extends SingletonSerializer<BigDecimal> {
        final BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        @Override
        public int getTypeId() {
            return -103;
        }

        @Override
        public BigDecimal read(ObjectDataInput in) throws IOException {
            BigInteger bigInt = this.bigIntegerSerializer.read(in);
            int scale = in.readInt();
            return new BigDecimal(bigInt, scale);
        }

        @Override
        public void write(ObjectDataOutput out, BigDecimal obj) throws IOException {
            BigInteger bigInt = obj.unscaledValue();
            int scale = obj.scale();
            this.bigIntegerSerializer.write(out, bigInt);
            out.writeInt(scale);
        }
    }

    public static final class BigIntegerSerializer
    extends SingletonSerializer<BigInteger> {
        @Override
        public int getTypeId() {
            return -102;
        }

        @Override
        public BigInteger read(ObjectDataInput in) throws IOException {
            byte[] bytes = new byte[in.readInt()];
            in.readFully(bytes);
            return new BigInteger(bytes);
        }

        @Override
        public void write(ObjectDataOutput out, BigInteger obj) throws IOException {
            byte[] bytes = obj.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }
}

