/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.request;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.core.Member;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.operation.ChangeWanStateOperation;
import com.hazelcast.internal.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.util.JsonUtil;
import java.io.IOException;
import java.util.Set;

public class ChangeWanStateRequest
implements ConsoleRequest {
    private String memberAddress;
    private String schemeName;
    private String publisherName;
    private boolean start;

    public ChangeWanStateRequest() {
    }

    public ChangeWanStateRequest(String member, String schemeName, String publisherName, boolean start) {
        this.memberAddress = member;
        this.schemeName = schemeName;
        this.publisherName = publisherName;
        this.start = start;
    }

    @Override
    public int getType() {
        return 33;
    }

    @Override
    public Object readResponse(JsonObject in) throws IOException {
        return "success";
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) throws Exception {
        JsonObject result = new JsonObject();
        result.add("start", this.start);
        ChangeWanStateOperation changeWanStateOperation = new ChangeWanStateOperation(this.schemeName, this.publisherName, this.start);
        String[] hostAndPort = this.memberAddress.split(":");
        Address address = new Address(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        Set<Member> members = mcs.getHazelcastInstance().getCluster().getMembers();
        for (Member member : members) {
            if (!member.getAddress().equals(address)) continue;
            mcs.callOnMember(member, changeWanStateOperation);
            break;
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("member", this.memberAddress);
        root.add("schemeName", this.schemeName);
        root.add("publisherName", this.publisherName);
        root.add("start", this.start);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.memberAddress = JsonUtil.getString(json, "member");
        this.schemeName = JsonUtil.getString(json, "schemeName");
        this.publisherName = JsonUtil.getString(json, "publisherName");
        this.start = JsonUtil.getBoolean(json, "start");
    }
}

