/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.instance.GroupProperty;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private static final byte[] QUEUE_SIMPLE_VALUE_CONTENT_TYPE = StringUtil.stringToBytes("text/plain");

    public HttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpPostCommand command) {
        try {
            String uri = command.getURI();
            if (uri.startsWith("/hazelcast/rest/maps/")) {
                this.handleMap(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/mancenter/changeurl")) {
                this.handleManagementCenterUrlChange(command);
            } else if (uri.startsWith("/hazelcast/rest/queues/")) {
                this.handleQueue(command, uri);
            } else {
                command.setResponse(HttpCommand.RES_400);
            }
        }
        catch (Exception e) {
            command.setResponse(HttpCommand.RES_500);
        }
        this.textCommandService.sendResponse(command);
    }

    private void handleQueue(HttpPostCommand command, String uri) {
        byte[] contentType;
        byte[] data;
        String queueName;
        String simpleValue = null;
        String suffix = uri.endsWith("/") ? uri.substring("/hazelcast/rest/queues/".length(), uri.length() - 1) : uri.substring("/hazelcast/rest/queues/".length(), uri.length());
        int indexSlash = suffix.lastIndexOf(47);
        if (indexSlash == -1) {
            queueName = suffix;
        } else {
            queueName = suffix.substring(0, indexSlash);
            simpleValue = suffix.substring(indexSlash + 1, suffix.length());
        }
        if (simpleValue == null) {
            data = command.getData();
            contentType = command.getContentType();
        } else {
            data = StringUtil.stringToBytes(simpleValue);
            contentType = QUEUE_SIMPLE_VALUE_CONTENT_TYPE;
        }
        boolean offerResult = this.textCommandService.offer(queueName, new RestValue(data, contentType));
        if (offerResult) {
            command.send200();
        } else {
            command.setResponse(HttpCommand.RES_503);
        }
    }

    private void handleManagementCenterUrlChange(HttpPostCommand command) throws UnsupportedEncodingException {
        if (this.textCommandService.getNode().getGroupProperties().getBoolean(GroupProperty.MC_URL_CHANGE_ENABLED)) {
            byte[] res = HttpCommand.RES_204;
            byte[] data = command.getData();
            String[] strList = StringUtil.bytesToString(data).split("&");
            String cluster = URLDecoder.decode(strList[0], "UTF-8");
            String pass = URLDecoder.decode(strList[1], "UTF-8");
            String url = URLDecoder.decode(strList[2], "UTF-8");
            ManagementCenterService managementCenterService = this.textCommandService.getNode().getManagementCenterService();
            if (managementCenterService != null) {
                res = managementCenterService.clusterWideUpdateManagementCenterUrl(cluster, pass, url);
            }
            command.setResponse(res);
        } else {
            command.setResponse(HttpCommand.RES_503);
        }
    }

    private void handleMap(HttpPostCommand command, String uri) {
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
        String key = uri.substring(indexEnd + 1);
        byte[] data = command.getData();
        this.textCommandService.put(mapName, key, new RestValue(data, command.getContentType()), -1);
        command.send200();
    }

    @Override
    public void handleRejection(HttpPostCommand command) {
        this.handle(command);
    }
}

