/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.ConfigCheck;
import com.hazelcast.cluster.impl.DiscoveryJoiner;
import com.hazelcast.cluster.impl.JoinMessage;
import com.hazelcast.cluster.impl.JoinRequest;
import com.hazelcast.cluster.impl.MulticastJoiner;
import com.hazelcast.cluster.impl.MulticastService;
import com.hazelcast.cluster.impl.TcpIpJoiner;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.instance.NodeExtensionFactory;
import com.hazelcast.instance.NodeShutdownHelper;
import com.hazelcast.instance.NodeState;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.TextCommandServiceImpl;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceSettings;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.VersionCheck;
import java.lang.reflect.Constructor;
import java.nio.channels.ServerSocketChannel;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Node {
    private final ILogger logger;
    private final AtomicBoolean joined = new AtomicBoolean(false);
    private volatile NodeState state;
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private final NodeShutdownHookThread shutdownHookThread = new NodeShutdownHookThread("hz.ShutdownThread");
    private final SerializationService serializationService;
    public final NodeEngineImpl nodeEngine;
    public final ClientEngineImpl clientEngine;
    public final InternalPartitionServiceImpl partitionService;
    public final ClusterServiceImpl clusterService;
    public final MulticastService multicastService;
    public final DiscoveryService discoveryService;
    public final ConnectionManager connectionManager;
    public final TextCommandServiceImpl textCommandService;
    public final Config config;
    public final GroupProperties groupProperties;
    public final Address address;
    public final MemberImpl localMember;
    private volatile Address masterAddress;
    public final HazelcastInstanceImpl hazelcastInstance;
    public final LoggingServiceImpl loggingService;
    private final Joiner joiner;
    private final NodeExtension nodeExtension;
    private ManagementCenterService managementCenterService;
    public final SecurityContext securityContext;
    private final ClassLoader configClassLoader;
    private final BuildInfo buildInfo;
    private final VersionCheck versionCheck = new VersionCheck();
    private final HazelcastThreadGroup hazelcastThreadGroup;
    private final boolean liteMember;

    public Node(HazelcastInstanceImpl hazelcastInstance, Config config, NodeContext nodeContext) {
        this.hazelcastInstance = hazelcastInstance;
        this.config = config;
        this.liteMember = config.isLiteMember();
        this.configClassLoader = config.getClassLoader();
        this.groupProperties = new GroupProperties(config);
        this.buildInfo = BuildInfoProvider.getBuildInfo();
        String loggingType = this.groupProperties.getString(GroupProperty.LOGGING_TYPE);
        this.loggingService = new LoggingServiceImpl(config.getGroupConfig().getName(), loggingType, this.buildInfo);
        AddressPicker addressPicker = nodeContext.createAddressPicker(this);
        try {
            addressPicker.pickAddress();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
        ServerSocketChannel serverSocketChannel = addressPicker.getServerSocketChannel();
        try {
            this.address = addressPicker.getPublicAddress();
            Map<String, Object> memberAttributes = this.findMemberAttributes(config.getMemberAttributeConfig().asReadOnly());
            this.localMember = new MemberImpl(this.address, true, UuidUtil.createMemberUuid(this.address), hazelcastInstance, memberAttributes, this.liteMember);
            this.loggingService.setThisMember(this.localMember);
            this.logger = this.loggingService.getLogger(Node.class.getName());
            this.hazelcastThreadGroup = new HazelcastThreadGroup(hazelcastInstance.getName(), this.logger, this.configClassLoader);
            this.nodeExtension = NodeExtensionFactory.create(this);
            this.nodeExtension.beforeStart();
            this.serializationService = this.nodeExtension.createSerializationService();
            this.securityContext = config.getSecurityConfig().isEnabled() ? this.nodeExtension.getSecurityContext() : null;
            this.nodeEngine = new NodeEngineImpl(this);
            this.clientEngine = new ClientEngineImpl(this);
            this.connectionManager = nodeContext.createConnectionManager(this, serverSocketChannel);
            this.partitionService = new InternalPartitionServiceImpl(this);
            this.clusterService = new ClusterServiceImpl(this);
            this.textCommandService = new TextCommandServiceImpl(this);
            this.nodeExtension.printNodeInfo();
            this.multicastService = MulticastService.createMulticastService(addressPicker.getBindAddress(), this, config, this.logger);
            this.discoveryService = this.createDiscoveryService(config);
            this.initializeListeners(config);
            this.joiner = nodeContext.createJoiner(this);
        }
        catch (Throwable e) {
            try {
                serverSocketChannel.close();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    public HazelcastThreadGroup getHazelcastThreadGroup() {
        return this.hazelcastThreadGroup;
    }

    private DiscoveryService createDiscoveryService(Config config) {
        JoinConfig joinConfig = config.getNetworkConfig().getJoin();
        DiscoveryConfig discoveryConfig = joinConfig.getDiscoveryConfig().getAsReadOnly();
        DiscoveryServiceProvider factory = discoveryConfig.getDiscoveryServiceProvider();
        if (factory == null) {
            factory = new DefaultDiscoveryServiceProvider();
        }
        ILogger logger = this.getLogger(DiscoveryService.class);
        DiscoveryServiceSettings settings = new DiscoveryServiceSettings().setConfigClassLoader(this.configClassLoader).setLogger(logger).setDiscoveryMode(DiscoveryMode.Member).setDiscoveryConfig(discoveryConfig).setDiscoveryNode(new SimpleDiscoveryNode(this.localMember.getAddress(), this.localMember.getAttributes()));
        return factory.newDiscoveryService(settings);
    }

    private void initializeListeners(Config config) {
        for (ListenerConfig listenerCfg : config.getListenerConfigs()) {
            EventListener listener = listenerCfg.getImplementation();
            if (listener == null) {
                try {
                    listener = ClassLoaderUtil.newInstance(this.configClassLoader, listenerCfg.getClassName());
                }
                catch (Exception e) {
                    this.logger.severe(e);
                }
            }
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(this.hazelcastInstance);
            }
            boolean known = false;
            if (listener instanceof DistributedObjectListener) {
                ProxyServiceImpl proxyService = (ProxyServiceImpl)this.nodeEngine.getProxyService();
                proxyService.addProxyListener((DistributedObjectListener)listener);
                known = true;
            }
            if (listener instanceof MembershipListener) {
                this.clusterService.addMembershipListener((MembershipListener)listener);
                known = true;
            }
            if (listener instanceof MigrationListener) {
                this.partitionService.addMigrationListener((MigrationListener)listener);
                known = true;
            }
            if (listener instanceof PartitionLostListener) {
                this.partitionService.addPartitionLostListener((PartitionLostListener)listener);
                known = true;
            }
            if (listener instanceof LifecycleListener) {
                this.hazelcastInstance.lifecycleService.addLifecycleListener((LifecycleListener)listener);
                known = true;
            }
            if (listener instanceof ClientListener) {
                String serviceName = "hz:core:clientEngine";
                this.nodeEngine.getEventService().registerLocalListener(serviceName, serviceName, listener);
                known = true;
            }
            if (listener == null || known) continue;
            String error = "Unknown listener type: " + listener.getClass();
            IllegalArgumentException t = new IllegalArgumentException(error);
            this.logger.warning(error, t);
        }
    }

    public ManagementCenterService getManagementCenterService() {
        return this.managementCenterService;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClusterServiceImpl getClusterService() {
        return this.clusterService;
    }

    public InternalPartitionService getPartitionService() {
        return this.partitionService;
    }

    public Address getMasterAddress() {
        return this.masterAddress;
    }

    public Address getThisAddress() {
        return this.address;
    }

    public MemberImpl getLocalMember() {
        return this.localMember;
    }

    public boolean joined() {
        return this.joined.get();
    }

    public boolean isMaster() {
        return this.address != null && this.address.equals(this.masterAddress);
    }

    public void setMasterAddress(Address master) {
        if (master != null && this.logger.isFinestEnabled()) {
            this.logger.finest("** setting master address to " + master);
        }
        this.masterAddress = master;
    }

    void start() {
        this.nodeEngine.start();
        this.connectionManager.start();
        if (this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            Thread multicastServiceThread = new Thread(this.hazelcastThreadGroup.getInternalThreadGroup(), this.multicastService, this.hazelcastThreadGroup.getThreadNamePrefix("MulticastThread"));
            multicastServiceThread.start();
        }
        if (this.groupProperties.getBoolean(GroupProperty.DISCOVERY_SPI_ENABLED)) {
            this.discoveryService.start();
        }
        if (this.groupProperties.getBoolean(GroupProperty.SHUTDOWNHOOK_ENABLED)) {
            this.logger.finest("Adding ShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.state = NodeState.ACTIVE;
        this.join();
        int clusterSize = this.clusterService.getSize();
        if (this.config.getNetworkConfig().isPortAutoIncrement() && this.address.getPort() >= this.config.getNetworkConfig().getPort() + clusterSize) {
            this.logger.warning("Config seed port is " + this.config.getNetworkConfig().getPort() + " and cluster size is " + clusterSize + ". Some of the ports seem occupied!");
        }
        try {
            this.managementCenterService = new ManagementCenterService(this.hazelcastInstance);
        }
        catch (Exception e) {
            this.logger.warning("ManagementCenterService could not be constructed!", e);
        }
        this.nodeExtension.afterStart();
        this.versionCheck.check(this, this.getBuildInfo().getVersion(), this.buildInfo.isEnterprise());
    }

    public void shutdown(boolean terminate) {
        long start = Clock.currentTimeMillis();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("We are being asked to shutdown when state = " + (Object)((Object)this.state));
        }
        if (!this.setShuttingDown()) {
            this.waitIfAlreadyShuttingDown();
            return;
        }
        if (!terminate) {
            int maxWaitSeconds = this.groupProperties.getSeconds(GroupProperty.GRACEFUL_SHUTDOWN_MAX_WAIT);
            if (!this.partitionService.prepareToSafeShutdown(maxWaitSeconds, TimeUnit.SECONDS)) {
                this.logger.warning("Graceful shutdown could not be completed in " + maxWaitSeconds + " seconds!");
            }
            try {
                this.clusterService.sendShutdownMessage();
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Shutdown message sent to other members");
                }
            }
            catch (Throwable t) {
                EmptyStatement.ignore(t);
            }
        } else {
            this.logger.warning("Terminating forcefully...");
        }
        this.joined.set(false);
        this.setMasterAddress(null);
        try {
            if (this.groupProperties.getBoolean(GroupProperty.SHUTDOWNHOOK_ENABLED)) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
            this.discoveryService.destroy();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        this.versionCheck.shutdown();
        if (this.managementCenterService != null) {
            this.managementCenterService.shutdown();
        }
        this.textCommandService.stop();
        if (this.multicastService != null) {
            this.logger.info("Shutting down multicast service...");
            this.multicastService.stop();
        }
        this.logger.info("Shutting down connection manager...");
        this.connectionManager.shutdown();
        this.logger.info("Shutting down node engine...");
        this.nodeEngine.shutdown(terminate);
        if (this.securityContext != null) {
            this.securityContext.destroy();
        }
        this.nodeExtension.destroy();
        this.logger.finest("Destroying serialization service...");
        this.serializationService.destroy();
        this.hazelcastThreadGroup.destroy();
        this.logger.info("Hazelcast Shutdown is completed in " + (Clock.currentTimeMillis() - start) + " ms.");
        this.state = NodeState.SHUT_DOWN;
    }

    private boolean setShuttingDown() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            this.state = NodeState.PASSIVE;
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return !this.shuttingDown.get();
    }

    private void waitIfAlreadyShuttingDown() {
        if (!this.shuttingDown.get()) {
            return;
        }
        this.logger.info("Node is already shutting down... Waiting for shutdown process to complete...");
        while (this.state != NodeState.SHUT_DOWN) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.warning("Interrupted while waiting for shutdown!");
                return;
            }
        }
    }

    public void changeNodeStateToActive() {
        ClusterState clusterState = this.clusterService.getClusterState();
        if (clusterState == ClusterState.PASSIVE) {
            throw new IllegalStateException("This method can be called only when cluster-state is not " + (Object)((Object)clusterState));
        }
        this.state = NodeState.ACTIVE;
    }

    public void changeNodeStateToPassive() {
        ClusterState clusterState = this.clusterService.getClusterState();
        if (clusterState != ClusterState.PASSIVE) {
            throw new IllegalStateException("This method can be called only when cluster-state is " + (Object)((Object)clusterState));
        }
        this.state = NodeState.PASSIVE;
    }

    public void reset() {
        this.state = NodeState.ACTIVE;
        this.setMasterAddress(null);
        this.joined.set(false);
        this.joiner.reset();
    }

    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    public ILogger getLogger(Class clazz) {
        return this.loggingService.getLogger(clazz);
    }

    public GroupProperties getGroupProperties() {
        return this.groupProperties;
    }

    public TextCommandService getTextCommandService() {
        return this.textCommandService;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClassLoader getConfigClassLoader() {
        return this.configClassLoader;
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    public NodeExtension getNodeExtension() {
        return this.nodeExtension;
    }

    public void setJoined() {
        this.joined.set(true);
    }

    public JoinMessage createSplitBrainJoinMessage() {
        return new JoinMessage(4, this.buildInfo.getBuildNumber(), this.address, this.localMember.getUuid(), this.localMember.isLiteMember(), this.createConfigCheck(), this.clusterService.getMemberAddresses());
    }

    public JoinRequest createJoinRequest(boolean withCredentials) {
        Credentials credentials = withCredentials && this.securityContext != null ? this.securityContext.getCredentialsFactory().newCredentials() : null;
        return new JoinRequest(4, this.buildInfo.getBuildNumber(), this.address, this.localMember.getUuid(), this.localMember.isLiteMember(), this.createConfigCheck(), credentials, this.config.getMemberAttributeConfig().getAttributes());
    }

    public ConfigCheck createConfigCheck() {
        String joinerType = this.joiner == null ? "" : this.joiner.getType();
        return new ConfigCheck(this.config, joinerType);
    }

    public void join() {
        if (this.joiner == null) {
            this.logger.warning("No join method is enabled! Starting standalone.");
            this.setAsMaster();
            return;
        }
        try {
            this.masterAddress = null;
            this.joined.set(false);
            this.clusterService.reset();
            this.joiner.join();
        }
        catch (Throwable e) {
            this.logger.severe("Error while joining the cluster!", e);
        }
        if (!this.joined()) {
            long maxJoinTimeMillis = this.groupProperties.getMillis(GroupProperty.MAX_JOIN_SECONDS);
            this.logger.severe("Could not join cluster in " + maxJoinTimeMillis + " ms. Shutting down now!");
            NodeShutdownHelper.shutdownNodeByFiringEvents(this, true);
        }
    }

    public Joiner getJoiner() {
        return this.joiner;
    }

    Joiner createJoiner() {
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        join.verify();
        if (this.groupProperties.getBoolean(GroupProperty.DISCOVERY_SPI_ENABLED)) {
            this.logger.info("Activating Discovery SPI Joiner");
            return new DiscoveryJoiner(this, this.discoveryService);
        }
        if (join.getMulticastConfig().isEnabled() && this.multicastService != null) {
            this.logger.info("Creating MulticastJoiner");
            return new MulticastJoiner(this);
        }
        if (join.getTcpIpConfig().isEnabled()) {
            this.logger.info("Creating TcpIpJoiner");
            return new TcpIpJoiner(this);
        }
        if (join.getAwsConfig().isEnabled()) {
            try {
                this.logger.info("Creating AWSJoiner");
                Class<?> clazz = Class.forName("com.hazelcast.cluster.impl.TcpIpJoinerOverAWS");
                Constructor<?> constructor = clazz.getConstructor(Node.class);
                return (Joiner)constructor.newInstance(this);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return null;
    }

    public void setAsMaster() {
        this.logger.finest("This node is being set as the master");
        this.masterAddress = this.address;
        this.setJoined();
        this.getClusterService().getClusterClock().setClusterStartTime(Clock.currentTimeMillis());
        this.getClusterService().setClusterId(UuidUtil.createClusterUuid());
    }

    public Config getConfig() {
        return this.config;
    }

    public NodeState getState() {
        return this.state;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public String toString() {
        return "Node[" + this.hazelcastInstance.getName() + "]";
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    private Map<String, Object> findMemberAttributes(MemberAttributeConfig attributeConfig) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(attributeConfig.getAttributes());
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("hazelcast.member.attribute.")) continue;
            String shortKey = key.substring("hazelcast.member.attribute.".length());
            String value = properties.getProperty(key);
            attributes.put(shortKey, value);
        }
        return attributes;
    }

    public class NodeShutdownHookThread
    extends Thread {
        NodeShutdownHookThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                if (Node.this.isRunning()) {
                    Node.this.logger.info("Running shutdown hook... Current state: " + (Object)((Object)Node.this.state));
                    Node.this.hazelcastInstance.getLifecycleService().terminate();
                }
            }
            catch (Exception e) {
                Node.this.logger.warning(e);
            }
        }
    }
}

