/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapAttributeConfigReadOnly;
import com.hazelcast.query.QueryConstants;
import com.hazelcast.util.Preconditions;

public class MapAttributeConfig {
    private String name;
    private String extractor;
    private MapAttributeConfigReadOnly readOnly;

    public MapAttributeConfig() {
    }

    public MapAttributeConfig(String name, String extractor) {
        this.setName(name);
        this.setExtractor(extractor);
    }

    public MapAttributeConfig(MapAttributeConfig config) {
        this.name = config.getName();
        this.extractor = config.getExtractor();
    }

    public MapAttributeConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MapAttributeConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public MapAttributeConfig setName(String name) {
        this.name = MapAttributeConfig.checkName(name);
        return this;
    }

    private static String checkName(String name) {
        Preconditions.checkHasText(name, "Map attribute name must contain text");
        MapAttributeConfig.checkNoDotInName(name);
        MapAttributeConfig.checkNotQueryConstant(name);
        return name;
    }

    private static void checkNoDotInName(String name) {
        if (name.contains(".")) {
            throw new IllegalArgumentException("Map attribute name must not contain . (dot) char");
        }
    }

    private static void checkNotQueryConstant(String name) {
        for (QueryConstants constant : QueryConstants.values()) {
            if (!name.equals(constant.value())) continue;
            throw new IllegalArgumentException(String.format("Map attribute name must not contain query constant '%s'", constant.value()));
        }
    }

    public String getExtractor() {
        return this.extractor;
    }

    public MapAttributeConfig setExtractor(String extractor) {
        this.extractor = Preconditions.checkHasText(extractor, "Map attribute extractor must contain text");
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapAttributeConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append("extractor='").append(this.extractor).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

