/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfigReadOnly;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.EntryListener;

public class EntryListenerConfig
extends ListenerConfig {
    private boolean local;
    private boolean includeValue = true;
    private EntryListenerConfigReadOnly readOnly;

    public EntryListenerConfig() {
    }

    public EntryListenerConfig(String className, boolean local, boolean includeValue) {
        super(className);
        this.local = local;
        this.includeValue = includeValue;
    }

    public EntryListenerConfig(EntryListener implementation, boolean local, boolean includeValue) {
        super(implementation);
        this.local = local;
        this.includeValue = includeValue;
    }

    public EntryListenerConfig(EntryListenerConfig config) {
        this.includeValue = config.isIncludeValue();
        this.local = config.isLocal();
        this.implementation = config.getImplementation();
        this.className = config.getClassName();
    }

    @Override
    public EntryListenerConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new EntryListenerConfigReadOnly(this);
        }
        return this.readOnly;
    }

    @Override
    public EntryListener getImplementation() {
        return (EntryListener)this.implementation;
    }

    public EntryListenerConfig setImplementation(EntryListener implementation) {
        super.setImplementation(implementation);
        return this;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    public EntryListenerConfig setLocal(boolean local) {
        this.local = local;
        return this;
    }

    @Override
    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public EntryListenerConfig setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    @Override
    public String toString() {
        return "EntryListenerConfig{local=" + this.local + ", includeValue=" + this.includeValue + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntryListenerConfig that = (EntryListenerConfig)o;
        if (this.includeValue != that.includeValue) {
            return false;
        }
        return this.local == that.local;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.local ? 1 : 0);
        result = 31 * result + (this.includeValue ? 1 : 0);
        return result;
    }
}

