/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.DiscoveryConfigReadOnly;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.spi.discovery.NodeFilter;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DiscoveryConfig {
    private final List<DiscoveryStrategyConfig> discoveryStrategyConfigs = new ArrayList<DiscoveryStrategyConfig>();
    private DiscoveryServiceProvider discoveryServiceProvider;
    private NodeFilter nodeFilter;
    private String nodeFilterClass;
    private DiscoveryConfig readonly;

    public DiscoveryConfig() {
    }

    protected DiscoveryConfig(DiscoveryServiceProvider discoveryServiceProvider, NodeFilter nodeFilter, String nodeFilterClass, Collection<DiscoveryStrategyConfig> discoveryStrategyConfigs) {
        this.discoveryServiceProvider = discoveryServiceProvider;
        this.nodeFilter = nodeFilter;
        this.nodeFilterClass = nodeFilterClass;
        this.discoveryStrategyConfigs.addAll(discoveryStrategyConfigs);
    }

    public DiscoveryConfig getAsReadOnly() {
        if (this.readonly != null) {
            return this.readonly;
        }
        this.readonly = new DiscoveryConfigReadOnly(this);
        return this.readonly;
    }

    public void setDiscoveryServiceProvider(DiscoveryServiceProvider discoveryServiceProvider) {
        this.discoveryServiceProvider = discoveryServiceProvider;
    }

    public DiscoveryServiceProvider getDiscoveryServiceProvider() {
        return this.discoveryServiceProvider;
    }

    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public String getNodeFilterClass() {
        return this.nodeFilterClass;
    }

    public void setNodeFilterClass(String nodeFilterClass) {
        this.nodeFilterClass = nodeFilterClass;
    }

    public boolean isEnabled() {
        return this.discoveryStrategyConfigs.size() > 0;
    }

    public Collection<DiscoveryStrategyConfig> getDiscoveryStrategyConfigs() {
        return this.discoveryStrategyConfigs;
    }

    public void addDiscoveryProviderConfig(DiscoveryStrategyConfig discoveryStrategyConfig) {
        this.discoveryStrategyConfigs.add(discoveryStrategyConfig);
    }
}

