/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue.operations;

import com.hazelcast.collection.impl.queue.QueueContainer;
import com.hazelcast.collection.impl.queue.operations.QueueBackupAwareOperation;
import com.hazelcast.collection.impl.txnqueue.operations.TxnPrepareBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class TxnPrepareOperation
extends QueueBackupAwareOperation {
    private long itemId;
    private boolean pollOperation;
    private String transactionId;

    public TxnPrepareOperation() {
    }

    public TxnPrepareOperation(int partitionId, String name, long itemId, boolean pollOperation, String transactionId) {
        super(name);
        this.setPartitionId(partitionId);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
        this.transactionId = transactionId;
    }

    @Override
    public void run() throws Exception {
        QueueContainer queueContainer = this.getOrCreateContainer();
        this.response = queueContainer.txnEnsureReserve(this.itemId);
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnPrepareBackupOperation(this.name, this.itemId, this.pollOperation, this.transactionId);
    }

    @Override
    public int getId() {
        return 28;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
        this.transactionId = in.readUTF();
    }
}

