/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.cluster.impl.operations.MemberInfoUpdateOperation;
import com.hazelcast.cluster.impl.operations.PostJoinOperation;
import com.hazelcast.core.Member;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class FinalizeJoinOperation
extends MemberInfoUpdateOperation
implements JoinOperation {
    public static final int FINALIZE_JOIN_TIMEOUT_FACTOR = 5;
    public static final int FINALIZE_JOIN_MAX_TIMEOUT = 60;
    private PostJoinOperation postJoinOp;
    private String clusterId;
    private long clusterStartTime;
    private ClusterState clusterState;

    public FinalizeJoinOperation() {
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime, String clusterId, long clusterStartTime, ClusterState clusterState) {
        super(members, masterTime, true);
        this.postJoinOp = postJoinOp;
        this.clusterId = clusterId;
        this.clusterStartTime = clusterStartTime;
        this.clusterState = clusterState;
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime, ClusterState clusterState, boolean sendResponse) {
        super(members, masterTime, sendResponse);
        this.postJoinOp = postJoinOp;
        this.clusterState = clusterState;
    }

    @Override
    public void run() throws Exception {
        if (!this.isValid()) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        clusterService.initialClusterState(this.clusterState);
        clusterService.setClusterId(this.clusterId);
        clusterService.getClusterClock().setClusterStartTime(this.clusterStartTime);
        this.processMemberUpdate();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Operation[] postJoinOperations = nodeEngine.getPostJoinOperations();
        InternalOperationService operationService = nodeEngine.getOperationService();
        if (this.clusterState == ClusterState.PASSIVE) {
            nodeEngine.getNode().changeNodeStateToPassive();
        } else {
            nodeEngine.getNode().changeNodeStateToActive();
        }
        if (postJoinOperations != null && postJoinOperations.length > 0) {
            Set<Member> members = clusterService.getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                PostJoinOperation operation = new PostJoinOperation(postJoinOperations);
                operationService.createInvocationBuilder("hz:core:clusterService", (Operation)operation, member.getAddress()).setTryCount(100).invoke();
            }
        }
        if (this.postJoinOp != null) {
            this.postJoinOp.setNodeEngine(nodeEngine);
            OperationAccessor.setCallerAddress(this.postJoinOp, this.getCallerAddress());
            OperationAccessor.setConnection(this.postJoinOp, this.getConnection());
            this.postJoinOp.setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
            operationService.runOperationOnCallingThread(this.postJoinOp);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        boolean hasPJOp = this.postJoinOp != null;
        out.writeBoolean(hasPJOp);
        if (hasPJOp) {
            this.postJoinOp.writeData(out);
        }
        out.writeUTF(this.clusterId);
        out.writeLong(this.clusterStartTime);
        out.writeUTF(this.clusterState.toString());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean hasPJOp = in.readBoolean();
        if (hasPJOp) {
            this.postJoinOp = new PostJoinOperation();
            this.postJoinOp.readData(in);
        }
        this.clusterId = in.readUTF();
        this.clusterStartTime = in.readLong();
        String stateName = in.readUTF();
        this.clusterState = ClusterState.valueOf(stateName);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", postJoinOp=").append(this.postJoinOp);
    }
}

