/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.impl.ClusterJoinManager;
import com.hazelcast.instance.Node;
import java.util.concurrent.atomic.AtomicBoolean;

final class SplitBrainHandler
implements Runnable {
    private final Node node;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);

    public SplitBrainHandler(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.shouldRun()) {
            return;
        }
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                this.searchForOtherClusters();
            }
            finally {
                this.inProgress.set(false);
            }
        }
    }

    private boolean shouldRun() {
        if (!this.node.joined()) {
            return false;
        }
        if (!this.node.isMaster()) {
            return false;
        }
        if (!this.node.isRunning()) {
            return false;
        }
        ClusterJoinManager clusterJoinManager = this.node.clusterService.getClusterJoinManager();
        return !clusterJoinManager.isJoinInProgress();
    }

    private void searchForOtherClusters() {
        Joiner joiner = this.node.getJoiner();
        if (joiner != null) {
            joiner.searchForOtherClusters();
        }
    }
}

