/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.TimeUnit;

public abstract class ClientCancellableDelegatingFuture<V>
extends ClientDelegatingFuture<V> {
    private static final int INVOCATION_WAIT_TIMEOUT_SECONDS = 5;
    protected final ClientContext context;
    protected final String uuid;
    protected volatile boolean cancelled;
    private final ILogger logger = Logger.getLogger(ClientCancellableDelegatingFuture.class);

    public ClientCancellableDelegatingFuture(ClientInvocationFuture future, ClientContext context, String uuid, V defaultValue, ClientMessageDecoder resultDecoder) {
        super(future, context.getSerializationService(), resultDecoder, defaultValue);
        this.context = context;
        this.uuid = uuid;
    }

    @Override
    public abstract boolean cancel(boolean var1);

    protected void waitForRequestToBeSend() {
        ClientInvocationFuture clientCallFuture = this.getFuture();
        ClientInvocation invocation = clientCallFuture.getInvocation();
        int timeoutSeconds = 5;
        while (!invocation.isInvoked()) {
            if (timeoutSeconds-- == 0) {
                this.logger.warning("Cancel is failed because runnable/callable never send to remote !");
                break;
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

