/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.nio.Address;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.UuidUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientNonSmartListenerService
extends ClientListenerServiceImpl {
    private final Map<ClientRegistrationKey, ClientEventRegistration> registrations = new ConcurrentHashMap<ClientRegistrationKey, ClientEventRegistration>();

    public ClientNonSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String registerListener(ListenerMessageCodec codec, EventHandler handler) {
        String userRegistrationId = UuidUtil.newUnsecureUuidString();
        ClientMessage request = codec.encodeAddRequest(false);
        ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, request, handler, codec);
        this.invoke(registrationKey);
        return userRegistrationId;
    }

    public void invoke(ClientRegistrationKey registrationKey) {
        EventHandler handler = registrationKey.getHandler();
        ClientMessage request = registrationKey.getRequest();
        handler.beforeListenerRegister();
        ClientInvocation invocation = new ClientInvocation(this.client, request);
        invocation.setEventHandler(handler);
        try {
            ClientInvocationFuture future = invocation.invoke();
            String registrationId = registrationKey.getCodec().decodeAddResponse(future.get());
            handler.onListenerRegister();
            Address address = future.getInvocation().getSendConnection().getRemoteEndpoint();
            ClientEventRegistration registration = new ClientEventRegistration(registrationId, request.getCorrelationId(), address, registrationKey.getCodec());
            this.registrations.put(registrationKey, registration);
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
    }

    @Override
    public boolean deregisterListener(String userRegistrationId) {
        ClientEventRegistration registration = this.registrations.remove(new ClientRegistrationKey(userRegistrationId));
        if (registration == null) {
            return false;
        }
        this.removeEventHandler(registration.getCallId());
        ClientMessage request = registration.getCodec().encodeRemoveRequest(registration.getServerRegistrationId());
        try {
            ClientInvocationFuture future = new ClientInvocation(this.client, request, registration.getSubscriber()).invoke();
            future.get();
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        return true;
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        Address ownerConnectionAddress = this.client.getClientClusterService().getOwnerConnectionAddress();
        if (membershipEvent.getMember().getAddress().equals(ownerConnectionAddress)) {
            this.executionService.executeInternal(new Runnable(){

                @Override
                public void run() {
                    for (ClientRegistrationKey registrationKey : ClientNonSmartListenerService.this.registrations.keySet()) {
                        ClientNonSmartListenerService.this.invoke(registrationKey);
                    }
                }
            });
        }
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        Address ownerConnectionAddress = this.client.getClientClusterService().getOwnerConnectionAddress();
        if (membershipEvent.getMember().getAddress().equals(ownerConnectionAddress)) {
            for (ClientEventRegistration registration : this.registrations.values()) {
                this.removeEventHandler(registration.getCallId());
            }
        }
    }

    @Override
    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }
}

