/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public abstract class ClientListenerServiceImpl
implements ClientListenerService,
MembershipListener {
    protected final HazelcastClientInstanceImpl client;
    protected final ClientExecutionServiceImpl executionService;
    protected final SerializationService serializationService;
    protected final ClientInvocationService invocationService;
    private final ConcurrentMap<Integer, EventHandler> eventHandlerMap = new ConcurrentHashMap<Integer, EventHandler>();
    private final ILogger logger = Logger.getLogger(ClientInvocationService.class);
    private final StripedExecutor eventExecutor;

    public ClientListenerServiceImpl(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        this.client = client;
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.invocationService = client.getInvocationService();
        this.serializationService = client.getSerializationService();
        client.getClientClusterService().addMembershipListener(this);
        this.eventExecutor = new StripedExecutor(this.logger, client.getName() + ".event", client.getThreadGroup(), eventThreadCount, eventQueueCapacity);
    }

    public void addEventHandler(int callId, EventHandler handler) {
        this.eventHandlerMap.put(callId, handler);
    }

    protected void removeEventHandler(int callId) {
        this.eventHandlerMap.remove(callId);
    }

    public void handleClientMessage(ClientMessage clientMessage) {
        try {
            this.eventExecutor.execute(new ClientEventProcessor(clientMessage));
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, " event clientMessage could not be handled ", e);
        }
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
    }

    public StripedExecutor getEventExecutor() {
        return this.eventExecutor;
    }

    private final class ClientEventProcessor
    implements StripedRunnable {
        final ClientMessage clientMessage;

        private ClientEventProcessor(ClientMessage clientMessage) {
            this.clientMessage = clientMessage;
        }

        @Override
        public void run() {
            int correlationId = this.clientMessage.getCorrelationId();
            EventHandler eventHandler = (EventHandler)ClientListenerServiceImpl.this.eventHandlerMap.get(correlationId);
            if (eventHandler == null) {
                ClientListenerServiceImpl.this.logger.warning("No eventHandler for callId: " + correlationId + ", event: " + this.clientMessage);
                return;
            }
            eventHandler.handle(this.clientMessage);
        }

        @Override
        public int getKey() {
            return this.clientMessage.getPartitionId();
        }
    }
}

