/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.HashUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private static final ILogger LOGGER = Logger.getLogger(ClientPartitionService.class);
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private static final int PARTITION_WAIT_TIME = 1000;
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentHashMap<Integer, Address> partitions = new ConcurrentHashMap(271, 0.75f, 1);
    private final AtomicBoolean updating = new AtomicBoolean(false);
    private volatile int partitionCount;

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public void start() {
        ClientExecutionService clientExecutionService = this.client.getClientExecutionService();
        clientExecutionService.scheduleWithFixedDelay(new RefreshTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public void refreshPartitions() {
        ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        try {
            executionService.executeInternal(new RefreshTask());
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private void getPartitionsBlocking() {
        while (!this.getPartitions() && this.client.getConnectionManager().isAlive()) {
            if (this.isClusterFormedByOnlyLiteMembers()) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isClusterFormedByOnlyLiteMembers() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        return clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).isEmpty();
    }

    private boolean getPartitions() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Address ownerAddress = clusterService.getOwnerConnectionAddress();
        if (ownerAddress == null) {
            return false;
        }
        Connection connection = this.client.getConnectionManager().getConnection(ownerAddress);
        ClientGetPartitionsCodec.ResponseParameters response = this.getPartitionsFrom(connection);
        if (response != null) {
            return this.processPartitionResponse(response);
        }
        return false;
    }

    private ClientGetPartitionsCodec.ResponseParameters getPartitionsFrom(Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this.client, requestMessage, connection).invoke();
            ClientMessage responseMessage = (ClientMessage)future.get();
            return ClientGetPartitionsCodec.decodeResponse(responseMessage);
        }
        catch (Exception e) {
            if (this.client.getLifecycleService().isRunning()) {
                LOGGER.severe("Error while fetching cluster partition table!", e);
            }
            return null;
        }
    }

    private boolean processPartitionResponse(ClientGetPartitionsCodec.ResponseParameters response) {
        Map<Address, Set<Integer>> partitionResponse = response.partitions;
        for (Map.Entry<Address, Set<Integer>> entry : partitionResponse.entrySet()) {
            Address address = entry.getKey();
            for (Integer partition : entry.getValue()) {
                this.partitions.put(partition, address);
            }
        }
        this.partitionCount = this.partitions.size();
        return partitionResponse.size() > 0;
    }

    public void stop() {
        this.partitions.clear();
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        Address address = this.partitions.get(partitionId);
        if (address == null) {
            this.getPartitionsBlocking();
        }
        return this.partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex(hash, pc);
    }

    @Override
    public int getPartitionId(Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        if (this.partitionCount == 0) {
            this.getPartitionsBlocking();
        }
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ClientPartitionServiceImpl.this.updating.compareAndSet(false, true)) {
                return;
            }
            try {
                ClientPartitionServiceImpl.this.getPartitions();
            }
            catch (HazelcastInstanceNotActiveException ignored) {
                EmptyStatement.ignore(ignored);
            }
            finally {
                ClientPartitionServiceImpl.this.updating.set(false);
            }
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + '}';
        }
    }
}

