/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MultiMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsEntryCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapValueCountCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapValuesCodec;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.AbstractIMapEvent;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";

    public ClientMultiMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    public boolean put(K key, V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapPutCodec.ResponseParameters resultParameters = MultiMapPutCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public Collection<V> get(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapGetCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapGetCodec.ResponseParameters resultParameters = MultiMapGetCodec.decodeResponse(response);
        List<Data> result = resultParameters.list;
        ArrayList resultCollection = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapRemoveEntryCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapRemoveEntryCodec.ResponseParameters resultParameters = MultiMapRemoveEntryCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public Collection<V> remove(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapRemoveCodec.ResponseParameters resultParameters = MultiMapRemoveCodec.decodeResponse(response);
        List<Data> result = resultParameters.list;
        ArrayList resultCollection = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    @Override
    public Set<K> keySet() {
        ClientMessage request = MultiMapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapKeySetCodec.ResponseParameters resultParameters = MultiMapKeySetCodec.decodeResponse(response);
        Set<Data> result = resultParameters.set;
        HashSet keySet = new HashSet(result.size());
        for (Data data : result) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        ClientMessage request = MultiMapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapValuesCodec.ResponseParameters resultParameters = MultiMapValuesCodec.decodeResponse(response);
        List<Data> result = resultParameters.list;
        ArrayList resultCollection = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MultiMapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapEntrySetCodec.ResponseParameters resultParameters = MultiMapEntrySetCodec.decodeResponse(response);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(resultParameters.entrySet.size());
        for (Map.Entry<Data, Data> entry : resultParameters.entrySet) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    @Override
    public boolean containsKey(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapContainsKeyCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapContainsKeyCodec.ResponseParameters resultParameters = MultiMapContainsKeyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyValue = this.toData(value);
        ClientMessage request = MultiMapContainsValueCodec.encodeRequest(this.name, keyValue);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapContainsValueCodec.ResponseParameters resultParameters = MultiMapContainsValueCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsEntry(K key, V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapContainsEntryCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapContainsEntryCodec.ResponseParameters resultParameters = MultiMapContainsEntryCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public int size() {
        ClientMessage request = MultiMapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapSizeCodec.ResponseParameters resultParameters = MultiMapSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void clear() {
        ClientMessage request = MultiMapClearCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public int valueCount(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapValueCountCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapValueCountCodec.ResponseParameters resultParameters = MultiMapValueCountCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.isNotNull(listener, "listener");
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.registerListener(this.createEntryListenerCodec(includeValue), handler);
    }

    private ListenerMessageCodec createEntryListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MultiMapAddEntryListenerCodec.encodeRequest(ClientMultiMapProxy.this.name, includeValue, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MultiMapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MultiMapRemoveEntryListenerCodec.encodeRequest(ClientMultiMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MultiMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        return this.registerListener(this.createEntryListenerToKeyCodec(includeValue, keyData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyCodec(final boolean includeValue, final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MultiMapAddEntryListenerToKeyCodec.encodeRequest(ClientMultiMapProxy.this.name, keyData, includeValue, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MultiMapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MultiMapRemoveEntryListenerCodec.encodeRequest(ClientMultiMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MultiMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public void lock(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), -1L);
        this.invoke(request, keyData);
    }

    @Override
    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkPositive(leaseTime, "leaseTime should be positive");
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit));
        this.invoke(request, keyData);
    }

    @Override
    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapIsLockedCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapIsLockedCodec.ResponseParameters resultParameters = MultiMapIsLockedCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean tryLock(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        try {
            return this.tryLock(key, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, Long.MAX_VALUE, null);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long timeoutInMillis = this.getTimeInMillis(time, timeunit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long threadId = ThreadUtil.getThreadId();
        ClientMessage request = MultiMapTryLockCodec.encodeRequest(this.name, keyData, threadId, leaseTimeInMillis, timeoutInMillis);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapTryLockCodec.ResponseParameters resultParameters = MultiMapTryLockCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void unlock(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapUnlockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    @Override
    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapForceUnlockCodec.encodeRequest(this.name, keyData);
        this.invoke(request, keyData);
    }

    @Override
    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-multimap-" + this.name);
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull(jobTracker, "jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMultiMap(this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator<Map.Entry, Result> collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture<Result> future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    @Override
    protected void onDestroy() {
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<ClientMessage> createHandler(Object listener, boolean includeValue) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return new ClientMultiMapEventHandler(listenerAdaptor, includeValue);
    }

    public String toString() {
        return "MultiMap{name='" + this.name + '\'' + '}';
    }

    private class ClientMultiMapEventHandler
    extends MultiMapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;
        private final boolean includeValue;

        public ClientMultiMapEventHandler(ListenerAdapter listenerAdapter, boolean includeValue) {
            this.listenerAdapter = listenerAdapter;
            this.includeValue = includeValue;
        }

        @Override
        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            Member member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(uuid);
            IMapEvent iMapEvent = this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member);
            this.listenerAdapter.onEvent(iMapEvent);
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            AbstractIMapEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(eventType, numberOfAffectedEntries, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)entryEventType));
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent(ClientMultiMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            Object value = null;
            Object oldValue = null;
            Object mergingValue = null;
            if (this.includeValue) {
                value = ClientMultiMapProxy.this.toObject(valueData);
                oldValue = ClientMultiMapProxy.this.toObject(oldValueData);
                mergingValue = ClientMultiMapProxy.this.toObject(mergingValueData);
            }
            Object key = ClientMultiMapProxy.this.toObject(keyData);
            return new EntryEvent<Object, Object>(ClientMultiMapProxy.this.name, member, eventType, key, oldValue, value, mergingValue);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

