/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddAllWithIndexCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddWithIndexCodec;
import com.hazelcast.client.impl.protocol.codec.ListClearCodec;
import com.hazelcast.client.impl.protocol.codec.ListCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListContainsCodec;
import com.hazelcast.client.impl.protocol.codec.ListGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListGetCodec;
import com.hazelcast.client.impl.protocol.codec.ListIndexOfCodec;
import com.hazelcast.client.impl.protocol.codec.ListIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.ListIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.ListLastIndexOfCodec;
import com.hazelcast.client.impl.protocol.codec.ListListIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.ListRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.ListRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ListRemoveWithIndexCodec;
import com.hazelcast.client.impl.protocol.codec.ListSetCodec;
import com.hazelcast.client.impl.protocol.codec.ListSizeCodec;
import com.hazelcast.client.impl.protocol.codec.ListSubCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ClientListProxy<E>
extends PartitionSpecificClientProxy
implements IList<E> {
    public ClientListProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = ListAddAllWithIndexCodec.encodeRequest(this.name, index, valueList);
        ClientMessage response = this.invokeOnPartition(request);
        ListAddAllWithIndexCodec.ResponseParameters resultParameters = ListAddAllWithIndexCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public E get(int index) {
        ClientMessage request = ListGetCodec.encodeRequest(this.name, index);
        ClientMessage response = this.invokeOnPartition(request);
        ListGetCodec.ResponseParameters resultParameters = ListGetCodec.decodeResponse(response);
        return (E)this.toObject(resultParameters.response);
    }

    @Override
    public E set(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ClientMessage request = ListSetCodec.encodeRequest(this.name, index, value);
        ClientMessage response = this.invokeOnPartition(request);
        ListSetCodec.ResponseParameters resultParameters = ListSetCodec.decodeResponse(response);
        return (E)this.toObject(resultParameters.response);
    }

    @Override
    public void add(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ClientMessage request = ListAddWithIndexCodec.encodeRequest(this.name, index, value);
        this.invokeOnPartition(request);
    }

    @Override
    public E remove(int index) {
        ClientMessage request = ListRemoveWithIndexCodec.encodeRequest(this.name, index);
        ClientMessage response = this.invokeOnPartition(request);
        ListRemoveWithIndexCodec.ResponseParameters resultParameters = ListRemoveWithIndexCodec.decodeResponse(response);
        return (E)this.toObject(resultParameters.response);
    }

    @Override
    public int size() {
        ClientMessage request = ListSizeCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        ListSizeCodec.ResponseParameters resultParameters = ListSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = ListIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        ListIsEmptyCodec.ResponseParameters resultParameters = ListIsEmptyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListContainsCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        ListContainsCodec.ResponseParameters resultParameters = ListContainsCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public Iterator<E> iterator() {
        ClientMessage request = ListIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        ListIteratorCodec.ResponseParameters resultParameters = ListIteratorCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.list;
        SerializationService serializationService = this.getContext().getSerializationService();
        return new UnmodifiableLazyList(resultCollection, serializationService).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data element = this.toData(e);
        ClientMessage request = ListAddCodec.encodeRequest(this.name, element);
        ClientMessage response = this.invokeOnPartition(request);
        ListAddCodec.ResponseParameters resultParameters = ListAddCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListRemoveCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        ListRemoveCodec.ResponseParameters resultParameters = ListRemoveCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = ListContainsAllCodec.encodeRequest(this.name, valueSet);
        ClientMessage response = this.invokeOnPartition(request);
        ListContainsAllCodec.ResponseParameters resultParameters = ListContainsAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = ListAddAllCodec.encodeRequest(this.name, valueList);
        ClientMessage response = this.invokeOnPartition(request);
        ListAddAllCodec.ResponseParameters resultParameters = ListAddAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = ListCompareAndRemoveAllCodec.encodeRequest(this.name, valueSet);
        ClientMessage response = this.invokeOnPartition(request);
        ListCompareAndRemoveAllCodec.ResponseParameters resultParameters = ListCompareAndRemoveAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = ListCompareAndRetainAllCodec.encodeRequest(this.name, valueSet);
        ClientMessage response = this.invokeOnPartition(request);
        ListCompareAndRetainAllCodec.ResponseParameters resultParameters = ListCompareAndRetainAllCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void clear() {
        ClientMessage request = ListClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    @Override
    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        ItemEventHandler eventHandler = new ItemEventHandler(includeValue, listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ListAddListenerCodec.encodeRequest(ClientListProxy.this.name, includeValue, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ListAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ListRemoveListenerCodec.encodeRequest(ClientListProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ListRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeItemListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    private Collection<E> getAll() {
        ClientMessage request = ListGetAllCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        ListGetAllCodec.ResponseParameters resultParameters = ListGetAllCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.list;
        ArrayList list = new ArrayList(resultCollection.size());
        for (Data value : resultCollection) {
            list.add(this.toObject(value));
        }
        return list;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListLastIndexOfCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        ListLastIndexOfCodec.ResponseParameters resultParameters = ListLastIndexOfCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public int indexOf(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListIndexOfCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        ListIndexOfCodec.ResponseParameters resultParameters = ListIndexOfCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        ClientMessage request = ListListIteratorCodec.encodeRequest(this.name, index);
        ClientMessage response = this.invokeOnPartition(request);
        ListListIteratorCodec.ResponseParameters resultParameters = ListListIteratorCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.list;
        SerializationService serializationService = this.getContext().getSerializationService();
        return new UnmodifiableLazyList(resultCollection, serializationService).listIterator();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ClientMessage request = ListSubCodec.encodeRequest(this.name, fromIndex, toIndex);
        ClientMessage response = this.invokeOnPartition(request);
        ListSubCodec.ResponseParameters resultParameters = ListSubCodec.decodeResponse(response);
        List<Data> resultCollection = resultParameters.list;
        SerializationService serializationService = this.getContext().getSerializationService();
        return new UnmodifiableLazyList(resultCollection, serializationService);
    }

    public String toString() {
        return "IList{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final boolean includeValue;
        private final ItemListener<E> listener;

        public ItemEventHandler(boolean includeValue, ItemListener<E> listener) {
            this.includeValue = includeValue;
            this.listener = listener;
        }

        @Override
        public void handle(Data dataItem, String uuid, int eventType) {
            SerializationService serializationService = ClientListProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientListProxy.this.getContext().getClusterService();
            Object item = this.includeValue ? (Object)serializationService.toObject(dataItem) : null;
            Member member = clusterService.getMember(uuid);
            ItemEvent<Object> itemEvent = new ItemEvent<Object>(ClientListProxy.this.name, ItemEventType.getByType(eventType), item, member);
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

