/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.ringbuffer;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.RingbufferReadManyAsyncCodec;
import com.hazelcast.client.impl.protocol.task.AbstractPartitionMessageTask;
import com.hazelcast.core.IFunction;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.operations.ReadManyOperation;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.spi.Operation;
import java.security.Permission;
import java.util.ArrayList;

public class RingbufferReadManyAsyncMessageTask
extends AbstractPartitionMessageTask<RingbufferReadManyAsyncCodec.RequestParameters> {
    public RingbufferReadManyAsyncMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        IFunction function = (IFunction)this.serializationService.toObject(((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).filter);
        return new ReadManyOperation(((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).name, ((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).startSequence, ((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).minCount, ((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).maxCount, function);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        ReadResultSetImpl resultSet = (ReadResultSetImpl)this.nodeEngine.getSerializationService().toObject(response);
        ArrayList<Data> items = new ArrayList<Data>(resultSet.size());
        for (int k = 0; k < resultSet.size(); ++k) {
            items.add(resultSet.getDataItems()[k]);
        }
        return RingbufferReadManyAsyncCodec.encodeResponse(resultSet.readCount(), items);
    }

    @Override
    protected RingbufferReadManyAsyncCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return RingbufferReadManyAsyncCodec.decodeRequest(clientMessage);
    }

    @Override
    public String getMethodName() {
        return "readManyAsync";
    }

    @Override
    public String getServiceName() {
        return "hz:impl:ringbufferService";
    }

    @Override
    public String getDistributedObjectName() {
        return ((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Permission getRequiredPermission() {
        return new RingBufferPermission(((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).startSequence, ((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).minCount, ((RingbufferReadManyAsyncCodec.RequestParameters)this.parameters).maxCount, null};
    }
}

