/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapExecuteWithPredicateCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAllPartitionsMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapExecuteWithPredicateMessageTask
extends AbstractMapAllPartitionsMessageTask<MapExecuteWithPredicateCodec.RequestParameters> {
    public MapExecuteWithPredicateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapOperationProvider operationProvider = this.getOperationProvider(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name);
        EntryProcessor entryProcessor = (EntryProcessor)this.serializationService.toObject(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).entryProcessor);
        Predicate predicate = (Predicate)this.serializationService.toObject(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).predicate);
        return operationProvider.createPartitionWideEntryWithPredicateOperationFactory(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name, entryProcessor, predicate);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Map.Entry<Data, Data>> dataMap = new HashSet<Map.Entry<Data, Data>>();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntries mapEntries = (MapEntries)mapService.getMapServiceContext().toObject(o);
            for (Map.Entry<Data, Data> entry : mapEntries) {
                dataMap.add(entry);
            }
        }
        return dataMap;
    }

    @Override
    protected MapExecuteWithPredicateCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapExecuteWithPredicateCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapExecuteWithPredicateCodec.encodeResponse((Set)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "executeOnEntries";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).entryProcessor, ((MapExecuteWithPredicateCodec.RequestParameters)this.parameters).predicate};
    }
}

