/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.XATransactionMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Set;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class XATransactionCollectTransactionsCodec {
    public static final XATransactionMessageType REQUEST_TYPE = XATransactionMessageType.XATRANSACTION_COLLECTTRANSACTIONS;
    public static final int RESPONSE_TYPE = 113;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(Set<Data> set) {
        int requiredDataSize = ResponseParameters.calculateDataSize(set);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(113);
        clientMessage.set(set.size());
        for (Data set_item : set) {
            clientMessage.set(set_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashSet<Data> set = null;
        int set_size = clientMessage.getInt();
        set = new HashSet<Data>(set_size);
        for (int set_index = 0; set_index < set_size; ++set_index) {
            Data set_item = clientMessage.getData();
            set.add(set_item);
        }
        parameters.set = set;
        return parameters;
    }

    public static class ResponseParameters {
        public Set<Data> set;

        public static int calculateDataSize(Set<Data> set) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Data set_item : set) {
                dataSize += ParameterUtil.calculateDataSize(set_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final XATransactionMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

