/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SetMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Set;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class SetContainsAllCodec {
    public static final SetMessageType REQUEST_TYPE = SetMessageType.SET_CONTAINSALL;
    public static final int RESPONSE_TYPE = 101;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Set<Data> valueSet) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, valueSet);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(valueSet.size());
        for (Data valueSet_item : valueSet) {
            clientMessage.set(valueSet_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        HashSet<Data> valueSet = null;
        int valueSet_size = clientMessage.getInt();
        valueSet = new HashSet<Data>(valueSet_size);
        for (int valueSet_index = 0; valueSet_index < valueSet_size; ++valueSet_index) {
            Data valueSet_item = clientMessage.getData();
            valueSet.add(valueSet_item);
        }
        parameters.valueSet = valueSet;
        return parameters;
    }

    public static ClientMessage encodeResponse(boolean response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(101);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        boolean response;
        ResponseParameters parameters = new ResponseParameters();
        parameters.response = response = clientMessage.getBoolean();
        return parameters;
    }

    public static class ResponseParameters {
        public boolean response;

        public static int calculateDataSize(boolean response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return ++dataSize;
        }
    }

    public static class RequestParameters {
        public static final SetMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Set<Data> valueSet;

        public static int calculateDataSize(String name, Set<Data> valueSet) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += 4;
            for (Data valueSet_item : valueSet) {
                dataSize += ParameterUtil.calculateDataSize(valueSet_item);
            }
            return dataSize;
        }
    }
}

