/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ReplicatedMapEntrySetCodec {
    public static final ReplicatedMapMessageType REQUEST_TYPE = ReplicatedMapMessageType.REPLICATEDMAP_ENTRYSET;
    public static final int RESPONSE_TYPE = 117;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String name) {
        int requiredDataSize = RequestParameters.calculateDataSize(name);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(name);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        return parameters;
    }

    public static ClientMessage encodeResponse(List<Map.Entry<Data, Data>> entrySet) {
        int requiredDataSize = ResponseParameters.calculateDataSize(entrySet);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(117);
        clientMessage.set(entrySet.size());
        for (Map.Entry<Data, Data> entrySet_item : entrySet) {
            clientMessage.set(entrySet_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        ArrayList<Map.Entry<Data, Data>> entrySet = null;
        int entrySet_size = clientMessage.getInt();
        entrySet = new ArrayList<Map.Entry<Data, Data>>(entrySet_size);
        for (int entrySet_index = 0; entrySet_index < entrySet_size; ++entrySet_index) {
            Map.Entry<Data, Data> entrySet_item = clientMessage.getMapEntry();
            entrySet.add(entrySet_item);
        }
        parameters.entrySet = entrySet;
        return parameters;
    }

    public static class ResponseParameters {
        public List<Map.Entry<Data, Data>> entrySet;

        public static int calculateDataSize(List<Map.Entry<Data, Data>> entrySet) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Map.Entry<Data, Data> entrySet_item : entrySet) {
                dataSize += ParameterUtil.calculateDataSize(entrySet_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final ReplicatedMapMessageType TYPE = REQUEST_TYPE;
        public String name;

        public static int calculateDataSize(String name) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += ParameterUtil.calculateDataSize(name);
        }
    }
}

