/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MultiMapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Set;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MultiMapKeySetCodec {
    public static final MultiMapMessageType REQUEST_TYPE = MultiMapMessageType.MULTIMAP_KEYSET;
    public static final int RESPONSE_TYPE = 113;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String name) {
        int requiredDataSize = RequestParameters.calculateDataSize(name);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(name);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        return parameters;
    }

    public static ClientMessage encodeResponse(Set<Data> set) {
        int requiredDataSize = ResponseParameters.calculateDataSize(set);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(113);
        clientMessage.set(set.size());
        for (Data set_item : set) {
            clientMessage.set(set_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashSet<Data> set = null;
        int set_size = clientMessage.getInt();
        set = new HashSet<Data>(set_size);
        for (int set_index = 0; set_index < set_size; ++set_index) {
            Data set_item = clientMessage.getData();
            set.add(set_item);
        }
        parameters.set = set;
        return parameters;
    }

    public static class ResponseParameters {
        public Set<Data> set;

        public static int calculateDataSize(Set<Data> set) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Data set_item : set) {
                dataSize += ParameterUtil.calculateDataSize(set_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MultiMapMessageType TYPE = REQUEST_TYPE;
        public String name;

        public static int calculateDataSize(String name) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += ParameterUtil.calculateDataSize(name);
        }
    }
}

