/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapKeySetWithPagingPredicateCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_KEYSETWITHPAGINGPREDICATE;
    public static final int RESPONSE_TYPE = 106;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Data predicate) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, predicate);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(predicate);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data predicate = null;
        parameters.predicate = predicate = clientMessage.getData();
        return parameters;
    }

    public static ClientMessage encodeResponse(List<Data> list) {
        int requiredDataSize = ResponseParameters.calculateDataSize(list);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(106);
        clientMessage.set(list.size());
        for (Data list_item : list) {
            clientMessage.set(list_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        ArrayList<Data> list = null;
        int list_size = clientMessage.getInt();
        list = new ArrayList<Data>(list_size);
        for (int list_index = 0; list_index < list_size; ++list_index) {
            Data list_item = clientMessage.getData();
            list.add(list_item);
        }
        parameters.list = list;
        return parameters;
    }

    public static class ResponseParameters {
        public List<Data> list;

        public static int calculateDataSize(List<Data> list) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Data list_item : list) {
                dataSize += ParameterUtil.calculateDataSize(list_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data predicate;

        public static int calculateDataSize(String name, Data predicate) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            return dataSize += ParameterUtil.calculateDataSize(predicate);
        }
    }
}

