/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapExecuteOnKeysCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_EXECUTEONKEYS;
    public static final int RESPONSE_TYPE = 114;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Data entryProcessor, Set<Data> keys) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, entryProcessor, keys);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(entryProcessor);
        clientMessage.set(keys.size());
        for (Data keys_item : keys) {
            clientMessage.set(keys_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data entryProcessor = null;
        parameters.entryProcessor = entryProcessor = clientMessage.getData();
        HashSet<Data> keys = null;
        int keys_size = clientMessage.getInt();
        keys = new HashSet<Data>(keys_size);
        for (int keys_index = 0; keys_index < keys_size; ++keys_index) {
            Data keys_item = clientMessage.getData();
            keys.add(keys_item);
        }
        parameters.keys = keys;
        return parameters;
    }

    public static ClientMessage encodeResponse(Set<Map.Entry<Data, Data>> entrySet) {
        int requiredDataSize = ResponseParameters.calculateDataSize(entrySet);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(114);
        clientMessage.set(entrySet.size());
        for (Map.Entry<Data, Data> entrySet_item : entrySet) {
            clientMessage.set(entrySet_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashSet<Map.Entry<Data, Data>> entrySet = null;
        int entrySet_size = clientMessage.getInt();
        entrySet = new HashSet<Map.Entry<Data, Data>>(entrySet_size);
        for (int entrySet_index = 0; entrySet_index < entrySet_size; ++entrySet_index) {
            Map.Entry<Data, Data> entrySet_item = clientMessage.getMapEntry();
            entrySet.add(entrySet_item);
        }
        parameters.entrySet = entrySet;
        return parameters;
    }

    public static class ResponseParameters {
        public Set<Map.Entry<Data, Data>> entrySet;

        public static int calculateDataSize(Set<Map.Entry<Data, Data>> entrySet) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Map.Entry<Data, Data> entrySet_item : entrySet) {
                dataSize += ParameterUtil.calculateDataSize(entrySet_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data entryProcessor;
        public Set<Data> keys;

        public static int calculateDataSize(String name, Data entryProcessor, Set<Data> keys) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(entryProcessor);
            dataSize += 4;
            for (Data keys_item : keys) {
                dataSize += ParameterUtil.calculateDataSize(keys_item);
            }
            return dataSize;
        }
    }
}

