/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.EnterpriseMapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class EnterpriseMapPublisherCreateWithValueCodec {
    public static final EnterpriseMapMessageType REQUEST_TYPE = EnterpriseMapMessageType.ENTERPRISEMAP_PUBLISHERCREATEWITHVALUE;
    public static final int RESPONSE_TYPE = 114;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String mapName, String cacheName, Data predicate, int batchSize, int bufferSize, long delaySeconds, boolean populate, boolean coalesce) {
        int requiredDataSize = RequestParameters.calculateDataSize(mapName, cacheName, predicate, batchSize, bufferSize, delaySeconds, populate, coalesce);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(mapName);
        clientMessage.set(cacheName);
        clientMessage.set(predicate);
        clientMessage.set(batchSize);
        clientMessage.set(bufferSize);
        clientMessage.set(delaySeconds);
        clientMessage.set(populate);
        clientMessage.set(coalesce);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        boolean coalesce;
        boolean populate;
        long delaySeconds;
        int bufferSize;
        int batchSize;
        RequestParameters parameters = new RequestParameters();
        String mapName = null;
        parameters.mapName = mapName = clientMessage.getStringUtf8();
        String cacheName = null;
        parameters.cacheName = cacheName = clientMessage.getStringUtf8();
        Data predicate = null;
        parameters.predicate = predicate = clientMessage.getData();
        parameters.batchSize = batchSize = clientMessage.getInt();
        parameters.bufferSize = bufferSize = clientMessage.getInt();
        parameters.delaySeconds = delaySeconds = clientMessage.getLong();
        parameters.populate = populate = clientMessage.getBoolean();
        parameters.coalesce = coalesce = clientMessage.getBoolean();
        return parameters;
    }

    public static ClientMessage encodeResponse(Set<Map.Entry<Data, Data>> entrySet) {
        int requiredDataSize = ResponseParameters.calculateDataSize(entrySet);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(114);
        clientMessage.set(entrySet.size());
        for (Map.Entry<Data, Data> entrySet_item : entrySet) {
            clientMessage.set(entrySet_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashSet<Map.Entry<Data, Data>> entrySet = null;
        int entrySet_size = clientMessage.getInt();
        entrySet = new HashSet<Map.Entry<Data, Data>>(entrySet_size);
        for (int entrySet_index = 0; entrySet_index < entrySet_size; ++entrySet_index) {
            Map.Entry<Data, Data> entrySet_item = clientMessage.getMapEntry();
            entrySet.add(entrySet_item);
        }
        parameters.entrySet = entrySet;
        return parameters;
    }

    public static class ResponseParameters {
        public Set<Map.Entry<Data, Data>> entrySet;

        public static int calculateDataSize(Set<Map.Entry<Data, Data>> entrySet) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Map.Entry<Data, Data> entrySet_item : entrySet) {
                dataSize += ParameterUtil.calculateDataSize(entrySet_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final EnterpriseMapMessageType TYPE = REQUEST_TYPE;
        public String mapName;
        public String cacheName;
        public Data predicate;
        public int batchSize;
        public int bufferSize;
        public long delaySeconds;
        public boolean populate;
        public boolean coalesce;

        public static int calculateDataSize(String mapName, String cacheName, Data predicate, int batchSize, int bufferSize, long delaySeconds, boolean populate, boolean coalesce) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(mapName);
            dataSize += ParameterUtil.calculateDataSize(cacheName);
            dataSize += ParameterUtil.calculateDataSize(predicate);
            dataSize += 4;
            dataSize += 4;
            dataSize += 8;
            ++dataSize;
            return ++dataSize;
        }
    }
}

