/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.ClientMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ClientGetPartitionsCodec {
    public static final ClientMessageType REQUEST_TYPE = ClientMessageType.CLIENT_GETPARTITIONS;
    public static final int RESPONSE_TYPE = 108;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest() {
        int requiredDataSize = RequestParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        return parameters;
    }

    public static ClientMessage encodeResponse(Map<Address, Set<Integer>> partitions) {
        int requiredDataSize = ResponseParameters.calculateDataSize(partitions);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(108);
        clientMessage.set(partitions.size());
        for (Map.Entry<Address, Set<Integer>> entry : partitions.entrySet()) {
            Address key = entry.getKey();
            Set<Integer> val = entry.getValue();
            AddressCodec.encode(key, clientMessage);
            clientMessage.set(val.size());
            for (Integer val_item : val) {
                clientMessage.set(val_item);
            }
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashMap<Address, Set<Integer>> partitions = null;
        int partitions_size = clientMessage.getInt();
        partitions = new HashMap<Address, Set<Integer>>(partitions_size);
        for (int partitions_index = 0; partitions_index < partitions_size; ++partitions_index) {
            Address partitions_key = AddressCodec.decode(clientMessage);
            int partitions_val_size = clientMessage.getInt();
            HashSet<Integer> partitions_val = new HashSet<Integer>(partitions_val_size);
            for (int partitions_val_index = 0; partitions_val_index < partitions_val_size; ++partitions_val_index) {
                Integer partitions_val_item = clientMessage.getInt();
                partitions_val.add(partitions_val_item);
            }
            partitions.put(partitions_key, partitions_val);
        }
        parameters.partitions = partitions;
        return parameters;
    }

    public static class ResponseParameters {
        public Map<Address, Set<Integer>> partitions;

        public static int calculateDataSize(Map<Address, Set<Integer>> partitions) {
            int dataSize = ClientMessage.HEADER_SIZE;
            for (Map.Entry<Address, Set<Integer>> entry : partitions.entrySet()) {
                Address key = entry.getKey();
                Set<Integer> val = entry.getValue();
                dataSize += AddressCodec.calculateDataSize(key);
                dataSize += 4;
                for (Integer val_item : val) {
                    dataSize += ParameterUtil.calculateDataSize(val_item);
                }
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final ClientMessageType TYPE = REQUEST_TYPE;

        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }
}

