/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastProperty;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;

@PrivateApi
public enum ClientProperty implements HazelcastProperty
{
    SHUFFLE_MEMBER_LIST("hazelcast.client.shuffle.member.list", true),
    HEARTBEAT_TIMEOUT("hazelcast.client.heartbeat.timeout", 60000, TimeUnit.MILLISECONDS),
    HEARTBEAT_INTERVAL("hazelcast.client.heartbeat.interval", 5000, TimeUnit.MILLISECONDS),
    EVENT_THREAD_COUNT("hazelcast.client.event.thread.count", 5),
    EVENT_QUEUE_CAPACITY("hazelcast.client.event.queue.capacity", 1000000),
    INVOCATION_TIMEOUT_SECONDS("hazelcast.client.invocation.timeout.seconds", 120, TimeUnit.SECONDS);

    private final String name;
    private final String defaultValue;
    private final TimeUnit timeUnit;

    private ClientProperty(String name, boolean defaultValue) {
        this(name, defaultValue ? "true" : "false");
    }

    private ClientProperty(String name, Integer defaultValue) {
        this(name, String.valueOf(defaultValue));
    }

    private ClientProperty(String name, String defaultValue) {
        this(name, defaultValue, null);
    }

    private ClientProperty(String name, Integer defaultValue, TimeUnit timeUnit) {
        this(name, String.valueOf(defaultValue), timeUnit);
    }

    private ClientProperty(String name, String defaultValue, TimeUnit timeUnit) {
        Preconditions.checkHasText(name, "The property name cannot be null or empty!");
        this.name = name;
        this.defaultValue = defaultValue;
        this.timeUnit = timeUnit;
    }

    @Override
    public int getIndex() {
        return this.ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public TimeUnit getTimeUnit() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException(String.format("groupProperty %s has no TimeUnit defined!", this));
        }
        return this.timeUnit;
    }

    @Override
    public GroupProperty getParent() {
        return null;
    }

    @Override
    public void setSystemProperty(String value) {
        System.setProperty(this.name, value);
    }

    @Override
    public String getSystemProperty() {
        return System.getProperty(this.name);
    }

    @Override
    public String clearSystemProperty() {
        return System.clearProperty(this.name);
    }

    public String toString() {
        return this.name;
    }
}

