/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.hazelcast.cache.impl.nearcache.NearCacheExecutor;
import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheClearCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheReplaceCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V>
implements CacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    private static final ClientMessageDecoder getAndRemoveResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetAndRemoveCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder removeResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.valueOf(CacheRemoveCodec.decodeResponse((ClientMessage)clientMessage).response);
        }
    };
    private static final ClientMessageDecoder replaceResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheReplaceCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder getAndReplaceResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetAndReplaceCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder putResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CachePutCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder putIfAbsentResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.valueOf(CachePutIfAbsentCodec.decodeResponse((ClientMessage)clientMessage).response);
        }
    };
    protected final ILogger logger = Logger.getLogger(this.getClass());
    protected final HazelcastClientCacheManager cacheManager;
    protected final NearCacheManager nearCacheManager;
    protected NearCache<Data, Object> nearCache;
    protected String nearCacheMembershipRegistrationId;
    protected final ClientCacheStatisticsImpl statistics;
    protected final boolean statisticsEnabled;
    protected boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;

    protected AbstractClientInternalCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext);
        this.cacheManager = cacheManager;
        this.nearCacheManager = clientContext.getNearCacheManager();
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.initNearCache();
        this.statistics = this.nearCache != null ? new ClientCacheStatisticsImpl(System.currentTimeMillis(), this.nearCache.getNearCacheStats()) : new ClientCacheStatisticsImpl(System.currentTimeMillis());
        this.statisticsEnabled = cacheConfig.isStatisticsEnabled();
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.clientContext.getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE;
            NearCacheContext nearCacheContext = new NearCacheContext(this.nearCacheManager, this.clientContext.getSerializationService(), this.createNearCacheExecutor(this.clientContext.getExecutionService()));
            this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, nearCacheContext);
            this.registerInvalidationListener();
        }
    }

    private NearCacheExecutor createNearCacheExecutor(ClientExecutionService clientExecutionService) {
        return new ClientNearCacheExecutor(clientExecutionService);
    }

    @Override
    public void close() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
        super.close();
    }

    @Override
    public void destroy() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
        super.destroy();
    }

    protected ClientInvocationFuture invoke(ClientMessage req, int partitionId, int completionId) {
        boolean completionOperation;
        boolean bl = completionOperation = completionId != -1;
        if (completionOperation) {
            this.registerCompletionLatch(completionId, 1);
        }
        try {
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, req, partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            if (completionOperation) {
                this.waitCompletionLatch(completionId, f);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    protected ClientInvocationFuture invoke(ClientMessage req, Data keyData, int completionId) {
        int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
        return this.invoke(req, partitionId, completionId);
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    protected <T> ICompletableFuture<T> getAndRemoveAsyncInternal(K key, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        Data keyData = this.toData(key);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndRemoveCodec.encodeRequest(this.nameWithPrefix, keyData, completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        ClientDelegatingFuture<Object> delegatingFuture = new ClientDelegatingFuture<Object>(future, this.clientContext.getSerializationService(), getAndRemoveResponseDecoder);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(true, start, response);
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheRemoveCodec.encodeRequest(this.nameWithPrefix, keyData, oldValueData, completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        ClientDelegatingFuture<Object> delegatingFuture = new ClientDelegatingFuture<Object>(future, this.clientContext.getSerializationService(), removeResponseDecoder);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(false, start, response);
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnRemove(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCacheRemovals();
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheRemovals();
            this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
        }
    }

    protected <T> ICompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheReplaceCodec.encodeRequest(this.nameWithPrefix, keyData, oldValueData, newValueData, expiryPolicyData, completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        ClientDelegatingFuture<Object> delegatingFuture = new ClientDelegatingFuture<Object>(future, this.clientContext.getSerializationService(), replaceResponseDecoder);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(false, start, response);
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected <T> ICompletableFuture<T> replaceAndGetAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndReplaceCodec.encodeRequest(this.nameWithPrefix, keyData, newValueData, expiryPolicyData, completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        ClientDelegatingFuture<Object> delegatingFuture = new ClientDelegatingFuture<Object>(future, this.clientContext.getSerializationService(), getAndReplaceResponseDecoder);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(true, start, response);
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnReplace(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCachePuts();
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheHits();
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        } else {
            this.statistics.increaseCacheMisses();
        }
    }

    protected <T> ICompletableFuture<T> putAsyncInternal(K key, final V value, ExpiryPolicy expiryPolicy, final boolean isGet, boolean withCompletionEvent, final boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        final Data keyData = this.toData(key);
        final Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutCodec.encodeRequest(this.nameWithPrefix, keyData, valueData, expiryPolicyData, isGet, completionId);
        try {
            future = this.invoke(request, keyData, completionId);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        ClientDelegatingFuture<Object> delegatingFuture = new ClientDelegatingFuture<Object>(future, this.clientContext.getSerializationService(), putResponseDecoder);
        if (this.nearCache != null || async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (async && AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPut(isGet, start, responseData);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnPut(boolean isGet, long start, Object response) {
        this.statistics.increaseCachePuts();
        this.statistics.addPutTimeNanos(System.nanoTime() - start);
        if (isGet) {
            Object resp = this.clientContext.getSerializationService().toObject(response);
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (resp == null) {
                this.statistics.increaseCacheMisses();
            } else {
                this.statistics.increaseCacheHits();
            }
        }
    }

    protected ICompletableFuture<Boolean> putIfAbsentAsyncInternal(K key, final V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent, final boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        final Data keyData = this.toData(key);
        final Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutIfAbsentCodec.encodeRequest(this.nameWithPrefix, keyData, valueData, expiryPolicyData, completionId);
        try {
            future = this.invoke(request, keyData, completionId);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        ClientDelegatingFuture<Boolean> delegatingFuture = new ClientDelegatingFuture<Boolean>(future, this.clientContext.getSerializationService(), putIfAbsentResponseDecoder);
        if (this.nearCache != null || async && this.statisticsEnabled) {
            delegatingFuture.andThen((ExecutionCallback<Boolean>)new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (async && AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPutIfAbsent(start, (Boolean)response);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnPutIfAbsent(long start, boolean saved) {
        if (saved) {
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
    }

    protected void removeAllKeysInternal(Set<? extends K> keys) {
        long start = System.nanoTime();
        HashSet<Data> keysData = new HashSet<Data>();
        for (K key : keys) {
            keysData.add(this.toData(key));
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllKeysCodec.encodeRequest(this.nameWithPrefix, keysData, completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
            if (this.statisticsEnabled) {
                this.statistics.increaseCacheRemovals(keysData.size());
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void removeAllInternal() {
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllCodec.encodeRequest(this.nameWithPrefix, completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void clearInternal() {
        ClientMessage request = CacheClearCodec.encodeRequest(this.nameWithPrefix);
        try {
            this.invoke(request);
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void storeInNearCache(Data key, Data valueData, V value) {
        if (this.nearCache != null && valueData != null) {
            Object valueToStore = this.nearCache.selectToSave(value, valueData);
            this.nearCache.put(key, valueToStore);
        }
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.remove(key);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    protected String getListenerIdLocal(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.get(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        ClientListenerService listenerService = this.clientContext.getListenerService();
        for (String regId : listenerRegistrations) {
            listenerService.deregisterListener(regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    @Override
    public void countDownCompletionLatch(int countDownLatchId) {
        if (countDownLatchId != -1) {
            CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
            if (countDownLatch.getCount() == 0L) {
                this.deregisterCompletionLatch(countDownLatchId);
            }
        }
    }

    protected Integer registerCompletionLatch(Integer countDownLatchId, int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(countDownLatchId, countDownLatch);
            return countDownLatchId;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        if (countDownLatchId != -1) {
            this.syncLocks.remove(countDownLatchId);
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, ICompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            this.awaitLatch(countDownLatch, future);
        }
    }

    private void awaitLatch(CountDownLatch countDownLatch, ICompletableFuture future) throws ExecutionException {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                Object response;
                if (future != null && future.isDone() && (response = future.get()) instanceof Throwable) {
                    return;
                }
                if (!this.clientContext.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.nameWithPrefix + ") is closed !");
            }
            if (countDownLatch.getCount() > 0L) {
                this.logger.finest("Countdown latch wait timeout after " + MAX_COMPLETION_LATCH_WAIT_TIME + " milliseconds!");
            }
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    protected EventHandler createHandler(CacheEventListenerAdaptor<K, V> adaptor) {
        return new CacheEventHandler(adaptor);
    }

    protected ICompletableFuture createCompletedFuture(Object value) {
        return new CompletedFuture(this.clientContext.getSerializationService(), value, this.clientContext.getExecutionService().getAsyncExecutor());
    }

    private void registerInvalidationListener() {
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange()) {
            Client client = this.clientContext.getClusterService().getLocalClient();
            NearCacheInvalidationHandler handler = new NearCacheInvalidationHandler(client);
            ListenerMessageCodec listenerCodec = this.createInvalidationListenerCodec();
            this.nearCacheMembershipRegistrationId = this.clientContext.getListenerService().registerListener(listenerCodec, handler);
        }
    }

    private ListenerMessageCodec createInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddInvalidationListenerCodec.encodeRequest(AbstractClientInternalCacheProxy.this.nameWithPrefix, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest(AbstractClientInternalCacheProxy.this.nameWithPrefix, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void removeInvalidationListener() {
        String registrationId;
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange() && (registrationId = this.nearCacheMembershipRegistrationId) != null) {
            this.clientContext.getListenerService().deregisterListener(registrationId);
        }
    }

    private class NearCacheInvalidationHandler
    extends CacheAddInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final Client client;

        private NearCacheInvalidationHandler(Client client) {
            this.client = client;
        }

        @Override
        public void handle(String name, Data key, String sourceUuid) {
            if (this.client.getUuid().equals(sourceUuid)) {
                return;
            }
            if (key != null) {
                AbstractClientInternalCacheProxy.this.nearCache.remove(key);
            } else {
                AbstractClientInternalCacheProxy.this.nearCache.clear();
            }
        }

        @Override
        public void handle(String name, List<Data> keys, List<String> sourceUuids) {
            if (sourceUuids != null && !sourceUuids.isEmpty()) {
                Iterator<Data> keysIt = keys.iterator();
                Iterator<String> sourceUuidsIt = sourceUuids.iterator();
                while (keysIt.hasNext() && sourceUuidsIt.hasNext()) {
                    Data key = keysIt.next();
                    String sourceUuid = sourceUuidsIt.next();
                    if (this.client.getUuid().equals(sourceUuid)) continue;
                    AbstractClientInternalCacheProxy.this.nearCache.remove(key);
                }
            } else {
                for (Data key : keys) {
                    AbstractClientInternalCacheProxy.this.nearCache.remove(key);
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            AbstractClientInternalCacheProxy.this.nearCache.clear();
        }
    }

    private class CacheEventHandler
    extends CacheAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final CacheEventListenerAdaptor<K, V> adaptor;

        private CacheEventHandler(CacheEventListenerAdaptor<K, V> adaptor) {
            this.adaptor = adaptor;
        }

        @Override
        public void handle(int type, Set<CacheEventData> keys, int completionId) {
            this.adaptor.handle(type, keys, completionId);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }

    private static class ClientNearCacheExecutor
    implements NearCacheExecutor {
        private ClientExecutionService clientExecutionService;

        private ClientNearCacheExecutor(ClientExecutionService clientExecutionService) {
            this.clientExecutionService = clientExecutionService;
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.clientExecutionService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

