/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.NotifiableEventListener;
import java.util.ArrayList;
import java.util.List;

public final class CacheInvalidationListener
implements CacheEventListener,
NotifiableEventListener<ICacheService> {
    private final ClientEndpoint endpoint;
    private final int callId;
    private final CacheContext cacheContext;

    public CacheInvalidationListener(ClientEndpoint endpoint, int callId, CacheContext cacheContext) {
        this.endpoint = endpoint;
        this.callId = callId;
        this.cacheContext = cacheContext;
    }

    @Override
    public void handleEvent(Object eventObject) {
        if (!this.endpoint.isAlive()) {
            return;
        }
        if (eventObject instanceof CacheInvalidationMessage) {
            String targetUuid = this.endpoint.getUuid();
            if (eventObject instanceof CacheSingleInvalidationMessage) {
                CacheSingleInvalidationMessage message = (CacheSingleInvalidationMessage)eventObject;
                if (!targetUuid.equals(message.getSourceUuid())) {
                    this.endpoint.sendEvent(message.getName(), new CacheSingleInvalidationMessage(message.getName(), message.getKey(), null), this.callId);
                }
            } else if (eventObject instanceof CacheBatchInvalidationMessage) {
                CacheBatchInvalidationMessage message = (CacheBatchInvalidationMessage)eventObject;
                List<CacheSingleInvalidationMessage> invalidationMessages = message.getInvalidationMessages();
                ArrayList<CacheSingleInvalidationMessage> filteredMessages = new ArrayList<CacheSingleInvalidationMessage>(invalidationMessages.size());
                for (CacheSingleInvalidationMessage invalidationMessage : invalidationMessages) {
                    if (targetUuid.equals(invalidationMessage.getSourceUuid())) continue;
                    filteredMessages.add(new CacheSingleInvalidationMessage(null, invalidationMessage.getKey(), null));
                }
                this.endpoint.sendEvent(message.getName(), new CacheBatchInvalidationMessage(message.getName(), filteredMessages), this.callId);
            }
        }
    }

    @Override
    public void onRegister(ICacheService cacheService, String serviceName, String topic, EventRegistration registration) {
        this.cacheContext.increaseInvalidationListenerCount();
    }

    @Override
    public void onDeregister(ICacheService cacheService, String serviceName, String topic, EventRegistration registration) {
        this.cacheContext.decreaseInvalidationListenerCount();
    }
}

