/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.iobalancer;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.tcp.AbstractIOSelector;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.MigratableHandler;
import com.hazelcast.nio.tcp.iobalancer.LoadImbalance;
import com.hazelcast.util.ItemCounter;
import com.hazelcast.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

class LoadTracker {
    private final ILogger log;
    private final AbstractIOSelector[] selectors;
    private final Map<IOSelector, Set<MigratableHandler>> selectorToHandlers;
    private final ItemCounter<MigratableHandler> lastEventCounter = new ItemCounter();
    private final ItemCounter<IOSelector> selectorEvents = new ItemCounter();
    private final ItemCounter<MigratableHandler> handlerEventsCounter = new ItemCounter();
    private final Set<MigratableHandler> handlers = new CopyOnWriteArraySet<MigratableHandler>();
    private final LoadImbalance imbalance;

    LoadTracker(AbstractIOSelector[] selectors, LoggingService loggingService) {
        this.log = loggingService.getLogger(LoadTracker.class);
        this.selectors = new AbstractIOSelector[selectors.length];
        System.arraycopy(selectors, 0, this.selectors, 0, selectors.length);
        this.selectorToHandlers = new HashMap<IOSelector, Set<MigratableHandler>>();
        for (AbstractIOSelector selector : selectors) {
            this.selectorToHandlers.put(selector, new HashSet());
        }
        this.imbalance = new LoadImbalance(this.selectorToHandlers, this.handlerEventsCounter);
    }

    LoadImbalance updateImbalance() {
        this.clearWorkingImbalance();
        this.updateNewWorkingImbalance();
        this.updateNewFinalImbalance();
        this.printDebugTable();
        return this.imbalance;
    }

    private void updateNewFinalImbalance() {
        this.imbalance.minimumEvents = Long.MAX_VALUE;
        this.imbalance.maximumEvents = Long.MIN_VALUE;
        this.imbalance.sourceSelector = null;
        this.imbalance.destinationSelector = null;
        for (AbstractIOSelector selector : this.selectors) {
            long eventCount = this.selectorEvents.get(selector);
            if (eventCount > this.imbalance.maximumEvents) {
                this.imbalance.maximumEvents = eventCount;
                this.imbalance.sourceSelector = selector;
            }
            if (eventCount >= this.imbalance.minimumEvents) continue;
            this.imbalance.minimumEvents = eventCount;
            this.imbalance.destinationSelector = selector;
        }
    }

    private void updateNewWorkingImbalance() {
        for (MigratableHandler handler : this.handlers) {
            this.updateHandlerState(handler);
        }
    }

    private void updateHandlerState(MigratableHandler handler) {
        long handlerEventCount = this.getEventCountSinceLastCheck(handler);
        this.handlerEventsCounter.set(handler, handlerEventCount);
        IOSelector owner = handler.getOwner();
        this.selectorEvents.add(owner, handlerEventCount);
        Set<MigratableHandler> handlersOwnedBy = this.selectorToHandlers.get(owner);
        handlersOwnedBy.add(handler);
    }

    private long getEventCountSinceLastCheck(MigratableHandler handler) {
        long eventCount = handler.getEventCount();
        Long lastEventCount = this.lastEventCounter.getAndSet(handler, eventCount);
        return eventCount - lastEventCount;
    }

    private void clearWorkingImbalance() {
        this.handlerEventsCounter.reset();
        this.selectorEvents.reset();
        for (Set<MigratableHandler> handlerSet : this.selectorToHandlers.values()) {
            handlerSet.clear();
        }
    }

    void addHandler(MigratableHandler handler) {
        this.handlers.add(handler);
    }

    void removeHandler(MigratableHandler handler) {
        this.handlers.remove(handler);
    }

    private void printDebugTable() {
        if (!this.log.isFinestEnabled()) {
            return;
        }
        IOSelector minSelector = this.imbalance.destinationSelector;
        IOSelector maxSelector = this.imbalance.sourceSelector;
        if (minSelector == null || maxSelector == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(StringUtil.getLineSeperator()).append("------------").append(StringUtil.getLineSeperator());
        Long eventCountPerSelector = this.selectorEvents.get(minSelector);
        sb.append("Min Selector ").append(minSelector).append(" received ").append(eventCountPerSelector).append(" events. ");
        sb.append("It contains following handlers: ").append(StringUtil.getLineSeperator());
        this.appendSelectorInfo(minSelector, this.selectorToHandlers, sb);
        eventCountPerSelector = this.selectorEvents.get(maxSelector);
        sb.append("Max Selector ").append(maxSelector).append(" received ").append(eventCountPerSelector).append(" events. ");
        sb.append("It contains following handlers: ").append(StringUtil.getLineSeperator());
        this.appendSelectorInfo(maxSelector, this.selectorToHandlers, sb);
        sb.append("Other Selectors: ").append(StringUtil.getLineSeperator());
        for (AbstractIOSelector selector : this.selectors) {
            if (selector.equals(minSelector) || selector.equals(maxSelector)) continue;
            eventCountPerSelector = this.selectorEvents.get(selector);
            sb.append("Selector ").append(selector).append(" contains ").append(eventCountPerSelector).append(" and has these handlers: ").append(StringUtil.getLineSeperator());
            this.appendSelectorInfo(selector, this.selectorToHandlers, sb);
        }
        sb.append("------------").append(StringUtil.getLineSeperator());
        this.log.finest(sb.toString());
    }

    private void appendSelectorInfo(IOSelector minSelector, Map<IOSelector, Set<MigratableHandler>> selectorToHandlers, StringBuilder sb) {
        Set<MigratableHandler> handlerSet = selectorToHandlers.get(minSelector);
        for (MigratableHandler selectionHandler : handlerSet) {
            Long eventCountPerHandler = this.handlerEventsCounter.get(selectionHandler);
            sb.append(selectionHandler).append(":  ").append(eventCountPerHandler).append(StringUtil.getLineSeperator());
        }
        sb.append(StringUtil.getLineSeperator());
    }
}

