/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.nearcache.impl;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.cache.impl.nearcache.impl.DefaultNearCache;
import com.hazelcast.config.NearCacheConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultNearCacheManager
implements NearCacheManager {
    private final ConcurrentMap<String, NearCache> nearCacheMap = new ConcurrentHashMap<String, NearCache>();
    private final Object mutex = new Object();

    @Override
    public <K, V> NearCache<K, V> getNearCache(String name) {
        return (NearCache)this.nearCacheMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> NearCache<K, V> getOrCreateNearCache(String name, NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        NearCache<K, V> nearCache = (NearCache<K, V>)this.nearCacheMap.get(name);
        if (nearCache == null) {
            Object object = this.mutex;
            synchronized (object) {
                nearCache = (NearCache)this.nearCacheMap.get(name);
                if (nearCache == null) {
                    nearCache = this.createNearCache(name, nearCacheConfig, nearCacheContext);
                    this.nearCacheMap.put(name, nearCache);
                }
            }
        }
        return nearCache;
    }

    protected <K, V> NearCache<K, V> createNearCache(String name, NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        return new DefaultNearCache(name, nearCacheConfig, nearCacheContext);
    }

    @Override
    public Collection<NearCache> listAllNearCaches() {
        return this.nearCacheMap.values();
    }

    @Override
    public boolean clearNearCache(String name) {
        NearCache nearCache = (NearCache)this.nearCacheMap.get(name);
        if (nearCache != null) {
            nearCache.clear();
        }
        return nearCache != null;
    }

    @Override
    public void clearAllNearCaches() {
        for (NearCache nearCache : this.nearCacheMap.values()) {
            nearCache.clear();
        }
    }

    @Override
    public boolean destroyNearCache(String name) {
        NearCache nearCache = (NearCache)this.nearCacheMap.remove(name);
        if (nearCache != null) {
            nearCache.destroy();
        }
        return nearCache != null;
    }

    @Override
    public void destroyAllNearCaches() {
        for (NearCache nearCache : new HashSet(this.nearCacheMap.values())) {
            this.nearCacheMap.remove(nearCache.getName());
            nearCache.destroy();
        }
    }
}

