/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SessionState
implements IdentifiedDataSerializable {
    private final Map<String, Data> attributes = new HashMap<String, Data>(1);
    private final Set<String> jvmIds = new HashSet<String>(1);

    @Override
    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 6;
    }

    public Map<String, Data> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String key, Data value) {
        this.attributes.put(key, value);
    }

    public boolean addJvmId(String jvmId) {
        Preconditions.checkNotNull(jvmId, "JVM Id cannot be null.");
        return this.jvmIds.add(jvmId);
    }

    public boolean removeJvmId(String jvmId) {
        Preconditions.checkNotNull(jvmId, "JVM Id cannot be null.");
        return this.jvmIds.remove(jvmId);
    }

    public Set<String> getJvmIds() {
        return this.jvmIds;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.jvmIds.size());
        for (String string : this.jvmIds) {
            out.writeUTF(string);
        }
        out.writeInt(this.attributes.size());
        for (Map.Entry entry : this.attributes.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeData((Data)entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int jvmCount = in.readInt();
        for (int i = 0; i < jvmCount; ++i) {
            this.jvmIds.add(in.readUTF());
        }
        int attCount = in.readInt();
        for (int i = 0; i < attCount; ++i) {
            this.attributes.put(in.readUTF(), in.readData());
        }
    }

    public void set(Map<String, Data> attributes) {
        this.attributes.putAll(attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionState {");
        sb.append("referenceCount=" + this.jvmIds.size());
        sb.append(", attributes=" + (this.attributes == null ? 0 : this.attributes.size()));
        if (this.attributes != null) {
            for (Map.Entry<String, Data> entry : this.attributes.entrySet()) {
                Data data = entry.getValue();
                int len = data == null ? 0 : data.dataSize();
                sb.append("\n\t");
                sb.append(entry.getKey() + "[" + len + "]");
            }
        }
        sb.append("\n}");
        return sb.toString();
    }
}

