/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.quorum.impl.QuorumServiceImpl;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationutil.Operations;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

class OperationRunnerImpl
extends OperationRunner {
    static final int AD_HOC_PARTITION_ID = -2;
    private final ILogger logger;
    private final OperationServiceImpl operationService;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final AtomicLong executedOperationsCount;
    private InternalPartition internalPartition;

    public OperationRunnerImpl(OperationServiceImpl operationService, int partitionId) {
        super(partitionId);
        this.operationService = operationService;
        this.logger = operationService.logger;
        this.node = operationService.node;
        this.nodeEngine = operationService.nodeEngine;
        this.executedOperationsCount = operationService.executedOperationsCount;
    }

    @Override
    public void run(Runnable task) {
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = task;
        }
        try {
            task.run();
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private boolean publishCurrentTask() {
        return this.getPartitionId() != -2 && this.currentTask == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Operation op) {
        this.executedOperationsCount.incrementAndGet();
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = op;
        }
        try {
            if (this.timeout(op)) {
                return;
            }
            this.ensureNoPartitionProblems(op);
            this.ensureQuorumPresent(op);
            op.beforeRun();
            if (this.waitingNeeded(op)) {
                return;
            }
            op.run();
            this.handleResponse(op);
            this.afterRun(op);
        }
        catch (Throwable e) {
            this.handleOperationError(op, e);
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private void ensureQuorumPresent(Operation op) {
        QuorumServiceImpl quorumService = this.operationService.nodeEngine.getQuorumService();
        quorumService.ensureQuorumPresent(op);
    }

    private boolean waitingNeeded(Operation op) {
        if (!(op instanceof WaitSupport)) {
            return false;
        }
        WaitSupport waitSupport = (WaitSupport)((Object)op);
        if (waitSupport.shouldWait()) {
            this.nodeEngine.getWaitNotifyService().await(waitSupport);
            return true;
        }
        return false;
    }

    private boolean timeout(Operation op) {
        if (!this.operationService.isCallTimedOut(op)) {
            return false;
        }
        CallTimeoutResponse callTimeoutResponse = new CallTimeoutResponse(op.getCallId(), op.isUrgent());
        op.getResponseHandler().sendResponse(callTimeoutResponse);
        return true;
    }

    private void handleResponse(Operation op) throws Exception {
        ResponseHandler responseHandler;
        boolean returnsResponse = op.returnsResponse();
        Object response = null;
        if (op instanceof BackupAwareOperation) {
            BackupAwareOperation backupAwareOp = (BackupAwareOperation)((Object)op);
            int syncBackupCount = 0;
            if (backupAwareOp.shouldBackup()) {
                syncBackupCount = this.operationService.operationBackupHandler.backup(backupAwareOp);
            }
            if (returnsResponse) {
                response = new NormalResponse(op.getResponse(), op.getCallId(), syncBackupCount, op.isUrgent());
            }
        }
        if (!returnsResponse) {
            return;
        }
        if (response == null) {
            response = op.getResponse();
        }
        if ((responseHandler = op.getResponseHandler()) == null) {
            throw new IllegalStateException("ResponseHandler should not be null! " + op);
        }
        responseHandler.sendResponse(response);
    }

    private void afterRun(Operation op) {
        try {
            Notifier notifier;
            op.afterRun();
            if (op instanceof Notifier && (notifier = (Notifier)((Object)op)).shouldNotify()) {
                this.operationService.nodeEngine.getWaitNotifyService().notify(notifier);
            }
        }
        catch (Throwable e) {
            this.logOperationError(op, e);
        }
    }

    protected void ensureNoPartitionProblems(Operation op) {
        int partitionId = op.getPartitionId();
        if (partitionId < 0) {
            return;
        }
        if (partitionId != this.getPartitionId()) {
            throw new IllegalStateException("wrong partition, expected: " + this.getPartitionId() + " but found:" + partitionId);
        }
        if (this.internalPartition == null) {
            this.internalPartition = this.nodeEngine.getPartitionService().getPartition(partitionId);
        }
        if (this.retryDuringMigration(op) && this.internalPartition.isMigrating()) {
            throw new PartitionMigratingException(this.node.getThisAddress(), partitionId, op.getClass().getName(), op.getServiceName());
        }
        Address owner = this.internalPartition.getReplicaAddress(op.getReplicaIndex());
        if (op.validatesTarget() && !this.node.getThisAddress().equals(owner)) {
            throw new WrongTargetException(this.node.getThisAddress(), owner, partitionId, op.getReplicaIndex(), op.getClass().getName(), op.getServiceName());
        }
    }

    private boolean retryDuringMigration(Operation op) {
        return !(op instanceof ReadonlyOperation) && !Operations.isMigrationOperation(op);
    }

    private void handleOperationError(Operation operation, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        operation.logError(e);
        ResponseHandler responseHandler = operation.getResponseHandler();
        if (operation.returnsResponse() && responseHandler != null) {
            try {
                if (this.node.isActive()) {
                    responseHandler.sendResponse(e);
                } else if (responseHandler.isLocal()) {
                    responseHandler.sendResponse(new HazelcastInstanceNotActiveException());
                }
            }
            catch (Throwable t) {
                this.logger.warning("While sending op error... op: " + operation + ", error: " + e, t);
            }
        }
    }

    private void logOperationError(Operation op, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        op.logError(e);
    }

    @Override
    public void run(Packet packet) throws Exception {
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = packet;
        }
        Connection connection = packet.getConn();
        Address caller = connection.getEndPoint();
        Data data = packet.getData();
        try {
            Object object = this.nodeEngine.toObject(data);
            Operation op = (Operation)object;
            op.setNodeEngine(this.nodeEngine);
            OperationAccessor.setCallerAddress(op, caller);
            OperationAccessor.setConnection(op, connection);
            this.setCallerUuidIfNotSet(caller, op);
            ResponseHandlerFactory.setRemoteResponseHandler(this.nodeEngine, op);
            if (!this.ensureValidMember(op)) {
                return;
            }
            if (publishCurrentTask) {
                this.currentTask = null;
            }
            this.run(op);
        }
        catch (Throwable throwable) {
            long callId = IOUtil.extractOperationCallId(data, this.node.getSerializationService());
            this.operationService.send(new ErrorResponse(throwable, callId, packet.isUrgent()), caller);
            this.logOperationDeserializationException(throwable, callId);
            throw ExceptionUtil.rethrow(throwable);
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private boolean ensureValidMember(Operation op) {
        if (this.node.clusterService.getMember(op.getCallerAddress()) != null || Operations.isJoinOperation(op) || Operations.isWanReplicationOperation(op)) {
            return true;
        }
        CallerNotMemberException error = new CallerNotMemberException(op.getCallerAddress(), op.getPartitionId(), op.getClass().getName(), op.getServiceName());
        this.handleOperationError(op, error);
        return false;
    }

    private void setCallerUuidIfNotSet(Address caller, Operation op) {
        if (op.getCallerUuid() != null) {
            return;
        }
        MemberImpl callerMember = this.node.clusterService.getMember(caller);
        if (callerMember != null) {
            op.setCallerUuid(callerMember.getUuid());
        }
    }

    public void logOperationDeserializationException(Throwable t, long callId) {
        boolean returnsResponse;
        boolean bl = returnsResponse = callId != 0L;
        if (t instanceof RetryableException) {
            Level level;
            Level level2 = level = returnsResponse ? Level.FINEST : Level.WARNING;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, t.getClass().getName() + ": " + t.getMessage());
            }
        } else if (t instanceof OutOfMemoryError) {
            try {
                this.logger.log(Level.SEVERE, t.getMessage(), t);
            }
            catch (Throwable ignored) {
                this.logger.log(Level.SEVERE, ignored.getMessage(), t);
            }
        } else {
            Level level;
            Level level3 = level = this.operationService.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, t.getMessage(), t);
            }
        }
    }
}

