/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.internal.management.dto.ClientEndPointDTO;
import com.hazelcast.internal.management.dto.MXBeansDTO;
import com.hazelcast.monitor.LocalCacheStats;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.LocalInstanceStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalMemoryStats;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.monitor.LocalOperationStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.MemberPartitionState;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.monitor.impl.LocalCacheStatsImpl;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.LocalMemoryStatsImpl;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.monitor.impl.LocalOperationStatsImpl;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.monitor.impl.MemberPartitionStateImpl;
import com.hazelcast.util.JsonUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MemberStateImpl
implements MemberState {
    private String address;
    private Map<String, Long> runtimeProps = new HashMap<String, Long>();
    private Map<String, LocalMapStats> mapStats = new HashMap<String, LocalMapStats>();
    private Map<String, LocalMultiMapStats> multiMapStats = new HashMap<String, LocalMultiMapStats>();
    private Map<String, LocalQueueStats> queueStats = new HashMap<String, LocalQueueStats>();
    private Map<String, LocalTopicStats> topicStats = new HashMap<String, LocalTopicStats>();
    private Map<String, LocalExecutorStats> executorStats = new HashMap<String, LocalExecutorStats>();
    private Map<String, LocalCacheStats> cacheStats = new HashMap<String, LocalCacheStats>();
    private Collection<ClientEndPointDTO> clients = new HashSet<ClientEndPointDTO>();
    private MXBeansDTO beans = new MXBeansDTO();
    private LocalMemoryStats memoryStats = new LocalMemoryStatsImpl();
    private MemberPartitionState memberPartitionState = new MemberPartitionStateImpl();
    private LocalOperationStats operationStats = new LocalOperationStatsImpl();

    @Override
    public Map<String, Long> getRuntimeProps() {
        return this.runtimeProps;
    }

    public void setRuntimeProps(Map<String, Long> runtimeProps) {
        this.runtimeProps = runtimeProps;
    }

    @Override
    public LocalMapStats getLocalMapStats(String mapName) {
        return this.mapStats.get(mapName);
    }

    @Override
    public LocalMultiMapStats getLocalMultiMapStats(String mapName) {
        return this.multiMapStats.get(mapName);
    }

    @Override
    public LocalQueueStats getLocalQueueStats(String queueName) {
        return this.queueStats.get(queueName);
    }

    @Override
    public LocalTopicStats getLocalTopicStats(String topicName) {
        return this.topicStats.get(topicName);
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats(String executorName) {
        return this.executorStats.get(executorName);
    }

    @Override
    public LocalCacheStats getLocalCacheStats(String cacheName) {
        return this.cacheStats.get(cacheName);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void putLocalMapStats(String name, LocalMapStats localMapStats) {
        this.mapStats.put(name, localMapStats);
    }

    public void putLocalMultiMapStats(String name, LocalMultiMapStats localMultiMapStats) {
        this.multiMapStats.put(name, localMultiMapStats);
    }

    public void putLocalQueueStats(String name, LocalQueueStats localQueueStats) {
        this.queueStats.put(name, localQueueStats);
    }

    public void putLocalTopicStats(String name, LocalTopicStats localTopicStats) {
        this.topicStats.put(name, localTopicStats);
    }

    public void putLocalExecutorStats(String name, LocalExecutorStats localExecutorStats) {
        this.executorStats.put(name, localExecutorStats);
    }

    public void putLocalCacheStats(String name, LocalCacheStats localCacheStats) {
        this.cacheStats.put(name, localCacheStats);
    }

    @Override
    public Collection<ClientEndPointDTO> getClients() {
        return this.clients;
    }

    @Override
    public MXBeansDTO getMXBeans() {
        return this.beans;
    }

    public void setBeans(MXBeansDTO beans) {
        this.beans = beans;
    }

    public void setClients(Collection<ClientEndPointDTO> clients) {
        this.clients = clients;
    }

    @Override
    public LocalMemoryStats getLocalMemoryStats() {
        return this.memoryStats;
    }

    public void setLocalMemoryStats(LocalMemoryStats memoryStats) {
        this.memoryStats = memoryStats;
    }

    @Override
    public LocalOperationStats getOperationStats() {
        return this.operationStats;
    }

    public void setOperationStats(LocalOperationStats operationStats) {
        this.operationStats = operationStats;
    }

    @Override
    public MemberPartitionState getMemberPartitionState() {
        return this.memberPartitionState;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("address", this.address);
        JsonObject mapStatsObject = new JsonObject();
        for (Map.Entry<String, LocalMapStats> entry : this.mapStats.entrySet()) {
            mapStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("mapStats", mapStatsObject);
        JsonObject multimapStatsObject = new JsonObject();
        for (Map.Entry<String, LocalMultiMapStats> entry : this.multiMapStats.entrySet()) {
            multimapStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("multiMapStats", multimapStatsObject);
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, LocalQueueStats> entry : this.queueStats.entrySet()) {
            jsonObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("queueStats", jsonObject);
        JsonObject jsonObject2 = new JsonObject();
        for (Map.Entry<String, LocalTopicStats> entry : this.topicStats.entrySet()) {
            jsonObject2.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("topicStats", jsonObject2);
        JsonObject jsonObject3 = new JsonObject();
        for (Map.Entry<String, LocalExecutorStats> entry : this.executorStats.entrySet()) {
            jsonObject3.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("executorStats", jsonObject3);
        JsonObject jsonObject4 = new JsonObject();
        for (Map.Entry<String, LocalCacheStats> entry : this.cacheStats.entrySet()) {
            jsonObject4.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("cacheStats", jsonObject4);
        JsonObject jsonObject5 = new JsonObject();
        for (Map.Entry<String, Long> entry : this.runtimeProps.entrySet()) {
            jsonObject5.add(entry.getKey(), entry.getValue());
        }
        root.add("runtimeProps", jsonObject5);
        JsonArray jsonArray = new JsonArray();
        for (ClientEndPointDTO client : this.clients) {
            jsonArray.add(client.toJson());
        }
        root.add("clients", jsonArray);
        root.add("beans", this.beans.toJson());
        root.add("memoryStats", this.memoryStats.toJson());
        root.add("operationStats", this.operationStats.toJson());
        root.add("memberPartitionState", this.memberPartitionState.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonObject jsonMemberPartitionState;
        JsonObject jsonOperationStats;
        LocalInstanceStats stats;
        this.address = JsonUtil.getString(json, "address");
        for (Object next : JsonUtil.getObject(json, "mapStats")) {
            stats = new LocalMapStatsImpl();
            ((LocalMapStatsImpl)stats).fromJson(((JsonObject.Member)next).getValue().asObject());
            this.mapStats.put(((JsonObject.Member)next).getName(), (LocalMapStats)stats);
        }
        for (Object next : JsonUtil.getObject(json, "multiMapStats")) {
            stats = new LocalMultiMapStatsImpl();
            ((LocalMapStatsImpl)stats).fromJson(((JsonObject.Member)next).getValue().asObject());
            this.multiMapStats.put(((JsonObject.Member)next).getName(), (LocalMultiMapStats)stats);
        }
        for (Object next : JsonUtil.getObject(json, "queueStats")) {
            stats = new LocalQueueStatsImpl();
            ((LocalQueueStatsImpl)stats).fromJson(((JsonObject.Member)next).getValue().asObject());
            this.queueStats.put(((JsonObject.Member)next).getName(), (LocalQueueStats)stats);
        }
        for (Object next : JsonUtil.getObject(json, "topicStats")) {
            stats = new LocalTopicStatsImpl();
            ((LocalTopicStatsImpl)stats).fromJson(((JsonObject.Member)next).getValue().asObject());
            this.topicStats.put(((JsonObject.Member)next).getName(), (LocalTopicStats)stats);
        }
        for (Object next : JsonUtil.getObject(json, "executorStats")) {
            stats = new LocalExecutorStatsImpl();
            ((LocalExecutorStatsImpl)stats).fromJson(((JsonObject.Member)next).getValue().asObject());
            this.executorStats.put(((JsonObject.Member)next).getName(), (LocalExecutorStats)stats);
        }
        for (Object next : JsonUtil.getObject(json, "cacheStats", new JsonObject())) {
            stats = new LocalCacheStatsImpl();
            stats.fromJson(((JsonObject.Member)next).getValue().asObject());
            this.cacheStats.put(((JsonObject.Member)next).getName(), (LocalCacheStats)stats);
        }
        for (Object next : JsonUtil.getObject(json, "runtimeProps")) {
            this.runtimeProps.put(((JsonObject.Member)next).getName(), ((JsonObject.Member)next).getValue().asLong());
        }
        JsonArray jsonClients = JsonUtil.getArray(json, "clients");
        for (JsonValue jsonClient : jsonClients) {
            ClientEndPointDTO client = new ClientEndPointDTO();
            client.fromJson(jsonClient.asObject());
            this.clients.add(client);
        }
        this.beans = new MXBeansDTO();
        this.beans.fromJson(JsonUtil.getObject(json, "beans"));
        JsonObject jsonMemoryStats = JsonUtil.getObject(json, "memoryStats", null);
        if (jsonMemoryStats != null) {
            this.memoryStats.fromJson(jsonMemoryStats);
        }
        if ((jsonOperationStats = JsonUtil.getObject(json, "operationStats", null)) != null) {
            this.operationStats.fromJson(jsonOperationStats);
        }
        if ((jsonMemberPartitionState = JsonUtil.getObject(json, "memberPartitionState", null)) != null) {
            this.memberPartitionState = new MemberPartitionStateImpl();
            this.memberPartitionState.fromJson(jsonMemberPartitionState);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberStateImpl that = (MemberStateImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.executorStats != null ? !this.executorStats.equals(that.executorStats) : that.executorStats != null) {
            return false;
        }
        if (this.mapStats != null ? !this.mapStats.equals(that.mapStats) : that.mapStats != null) {
            return false;
        }
        if (this.multiMapStats != null ? !this.multiMapStats.equals(that.multiMapStats) : that.multiMapStats != null) {
            return false;
        }
        if (this.queueStats != null ? !this.queueStats.equals(that.queueStats) : that.queueStats != null) {
            return false;
        }
        if (this.runtimeProps != null ? !this.runtimeProps.equals(that.runtimeProps) : that.runtimeProps != null) {
            return false;
        }
        if (this.topicStats != null ? !this.topicStats.equals(that.topicStats) : that.topicStats != null) {
            return false;
        }
        if (this.cacheStats != null ? !this.cacheStats.equals(that.cacheStats) : that.cacheStats != null) {
            return false;
        }
        if (this.memoryStats != null ? !this.memoryStats.equals(that.memoryStats) : that.memoryStats != null) {
            return false;
        }
        if (this.operationStats != null ? !this.operationStats.equals(that.operationStats) : that.operationStats != null) {
            return false;
        }
        return !(this.memberPartitionState != null ? !this.memberPartitionState.equals(that.memberPartitionState) : that.memberPartitionState != null);
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.mapStats != null ? this.mapStats.hashCode() : 0);
        result = 31 * result + (this.multiMapStats != null ? this.multiMapStats.hashCode() : 0);
        result = 31 * result + (this.queueStats != null ? this.queueStats.hashCode() : 0);
        result = 31 * result + (this.topicStats != null ? this.topicStats.hashCode() : 0);
        result = 31 * result + (this.executorStats != null ? this.executorStats.hashCode() : 0);
        result = 31 * result + (this.cacheStats != null ? this.cacheStats.hashCode() : 0);
        result = 31 * result + (this.memberPartitionState != null ? this.memberPartitionState.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MemberStateImpl{address=" + this.address + ", runtimeProps=" + this.runtimeProps + ", mapStats=" + this.mapStats + ", multiMapStats=" + this.multiMapStats + ", queueStats=" + this.queueStats + ", topicStats=" + this.topicStats + ", executorStats=" + this.executorStats + ", cacheStats=" + this.cacheStats + ", memoryStats=" + this.memoryStats + ", operationStats=" + this.operationStats + ", memberPartitionState=" + this.memberPartitionState + '}';
    }
}

