/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.internal.management.JsonSerializable;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.util.JsonUtil;
import com.hazelcast.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TimedMemberState
implements Cloneable,
JsonSerializable {
    long time;
    MemberStateImpl memberState;
    Set<String> instanceNames;
    List<String> memberList;
    Boolean master;
    String clusterName;

    public List<String> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<String> memberList) {
        this.memberList = memberList;
    }

    public Boolean getMaster() {
        return this.master;
    }

    public void setMaster(Boolean master) {
        this.master = master;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Set<String> getInstanceNames() {
        return this.instanceNames;
    }

    public void setInstanceNames(Set<String> longInstanceNames) {
        this.instanceNames = longInstanceNames;
    }

    public MemberStateImpl getMemberState() {
        return this.memberState;
    }

    public void setMemberState(MemberStateImpl memberState) {
        this.memberState = memberState;
    }

    public TimedMemberState clone() throws CloneNotSupportedException {
        TimedMemberState state = (TimedMemberState)super.clone();
        state.setTime(this.time);
        state.setMemberState(this.memberState);
        state.setInstanceNames(this.instanceNames);
        state.setMemberList(this.memberList);
        state.setMaster(this.master);
        state.setClusterName(this.clusterName);
        return state;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("master", this.master);
        root.add("time", this.time);
        root.add("clusterName", this.clusterName);
        JsonArray instanceNames = new JsonArray();
        for (String instanceName : this.instanceNames) {
            instanceNames.add(instanceName);
        }
        root.add("instanceNames", instanceNames);
        if (this.memberList != null) {
            JsonArray members = new JsonArray();
            for (String member : this.memberList) {
                members.add(member);
            }
            root.add("memberList", members);
        }
        root.add("memberState", this.memberState.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.time = JsonUtil.getLong(json, "time");
        this.master = JsonUtil.getBoolean(json, "master");
        this.clusterName = JsonUtil.getString(json, "clusterName");
        this.instanceNames = new HashSet<String>();
        JsonArray jsonInstanceNames = JsonUtil.getArray(json, "instanceNames");
        for (JsonValue jsonValue : jsonInstanceNames.values()) {
            this.instanceNames.add(jsonValue.asString());
        }
        this.memberList = new ArrayList<String>();
        JsonArray jsonMemberList = JsonUtil.getArray(json, "memberList");
        for (JsonValue member : jsonMemberList.values()) {
            this.memberList.add(member.asString());
        }
        JsonObject jsonObject = JsonUtil.getObject(json, "memberState");
        this.memberState = new MemberStateImpl();
        this.memberState.fromJson(jsonObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedMemberState that = (TimedMemberState)o;
        if (this.time != that.time) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.instanceNames != null ? !this.instanceNames.equals(that.instanceNames) : that.instanceNames != null) {
            return false;
        }
        if (this.master != null ? !this.master.equals(that.master) : that.master != null) {
            return false;
        }
        if (this.memberList != null ? !this.memberList.equals(that.memberList) : that.memberList != null) {
            return false;
        }
        return !(this.memberState != null ? !this.memberState.equals(that.memberState) : that.memberState != null);
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (this.memberState != null ? this.memberState.hashCode() : 0);
        result = 31 * result + (this.instanceNames != null ? this.instanceNames.hashCode() : 0);
        result = 31 * result + (this.memberList != null ? this.memberList.hashCode() : 0);
        result = 31 * result + (this.master != null ? this.master.hashCode() : 0);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TimedMemberState{" + StringUtil.getLineSeperator() + '\t' + this.memberState + StringUtil.getLineSeperator() + "} Instances: " + this.instanceNames;
    }
}

