/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.map.impl.MapContextQuerySupport;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class QueryOperation
extends AbstractMapOperation
implements ReadonlyOperation {
    private static final long QUERY_EXECUTION_TIMEOUT_MINUTES = 5L;
    private Predicate predicate;
    private PagingPredicate pagingPredicate;
    private QueryResult result;

    public QueryOperation() {
    }

    public QueryOperation(String mapName, Predicate predicate) {
        super(mapName);
        this.predicate = predicate;
        if (predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)predicate;
        }
    }

    @Override
    public void run() throws Exception {
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        NodeEngine nodeEngine = this.getNodeEngine();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapContextQuerySupport mapQuerySupport = mapServiceContext.getMapContextQuerySupport();
        int partitionStateVersion = partitionService.getPartitionStateVersion();
        Collection<Integer> initialPartitions = mapServiceContext.getOwnedPartitions();
        Set<QueryableEntry> entries = null;
        if (!partitionService.hasOnGoingMigrationLocal()) {
            entries = this.mapContainer.getIndexService().query(this.predicate);
        }
        this.result = mapQuerySupport.newQueryResult(initialPartitions.size());
        if (entries != null) {
            this.result.addAll(entries);
        } else {
            this.fullTableScan(initialPartitions, nodeEngine.getGroupProperties());
        }
        Collection<Integer> finalPartitions = mapServiceContext.getOwnedPartitions();
        if (initialPartitions.equals(finalPartitions)) {
            this.result.setPartitionIds(finalPartitions);
        }
        if (this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            LocalMapStatsImpl localStats = mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.name);
            localStats.incrementOtherOperations();
        }
        this.checkPartitionStateChanges(partitionService, partitionStateVersion);
    }

    private void fullTableScan(Collection<Integer> initialPartitions, GroupProperties groupProperties) throws InterruptedException, ExecutionException {
        if (this.pagingPredicate != null) {
            this.runParallelForPaging(initialPartitions);
        } else {
            boolean parallelEvaluation = groupProperties.QUERY_PREDICATE_PARALLEL_EVALUATION.getBoolean();
            if (parallelEvaluation) {
                this.runParallel(initialPartitions);
            } else {
                this.runSingleThreaded(initialPartitions);
            }
        }
    }

    protected void runSingleThreaded(Collection<Integer> initialPartitions) {
        RetryableHazelcastException storedException = null;
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapContextQuerySupport querySupport = mapServiceContext.getMapContextQuerySupport();
        for (Integer partitionId : initialPartitions) {
            try {
                Collection<QueryableEntry> entries = querySupport.queryOnPartition(this.name, this.predicate, partitionId);
                this.result.addAll(entries);
            }
            catch (RetryableHazelcastException e) {
                if (storedException != null) continue;
                storedException = e;
            }
        }
        if (storedException != null) {
            throw storedException;
        }
    }

    private void runParallel(Collection<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        for (Integer partitionId : initialPartitions) {
            Future<Collection<QueryableEntry>> future = executor.submit(new PartitionCallable(partitionId));
            lsFutures.add(future);
        }
        Collection<Collection<QueryableEntry>> returnedResults = QueryOperation.getResult(lsFutures);
        for (Collection<QueryableEntry> returnedResult : returnedResults) {
            if (returnedResult == null) continue;
            this.result.addAll(returnedResult);
        }
    }

    private void runParallelForPaging(Collection<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        Comparator<Map.Entry> wrapperComparator = SortingUtil.newComparator(this.pagingPredicate);
        for (Integer partitionId : initialPartitions) {
            Future<Collection<QueryableEntry>> future = executor.submit(new PartitionCallable(partitionId));
            lsFutures.add(future);
        }
        List<QueryableEntry> toMerge = new LinkedList<QueryableEntry>();
        Collection<Collection<QueryableEntry>> returnedResults = QueryOperation.getResult(lsFutures);
        for (Collection<QueryableEntry> returnedResult : returnedResults) {
            toMerge.addAll(returnedResult);
        }
        Collections.sort(toMerge, wrapperComparator);
        if (toMerge.size() > this.pagingPredicate.getPageSize()) {
            toMerge = toMerge.subList(0, this.pagingPredicate.getPageSize());
        }
        this.result.addAll(toMerge);
    }

    private static Collection<Collection<QueryableEntry>> getResult(List<Future<Collection<QueryableEntry>>> lsFutures) {
        return FutureUtil.returnWithDeadline(lsFutures, 5L, TimeUnit.MINUTES, FutureUtil.RETHROW_EVERYTHING);
    }

    private void checkPartitionStateChanges(InternalPartitionService partitionService, int partitionStateVersion) {
        if (partitionStateVersion != partitionService.getPartitionStateVersion()) {
            this.getLogger().info("Partition assignments changed while executing query: " + this.predicate);
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        this.predicate = (Predicate)in.readObject();
        if (this.predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)this.predicate;
        }
    }

    private final class PartitionCallable
    implements Callable<Collection<QueryableEntry>> {
        private final int partition;

        private PartitionCallable(int partitionId) {
            this.partition = partitionId;
        }

        @Override
        public Collection<QueryableEntry> call() throws Exception {
            MapContextQuerySupport mapContextQuerySupport = QueryOperation.this.mapService.getMapServiceContext().getMapContextQuerySupport();
            return mapContextQuerySupport.queryOnPartition(QueryOperation.this.name, QueryOperation.this.predicate, this.partition);
        }
    }
}

